/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.Meta;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.com.google.protobuf.Descriptors;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.proto.Common;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.remote.ProtobufService;

public class ConnectionPropertiesImpl
implements Meta.ConnectionProperties {
    private boolean isDirty = false;
    private Boolean autoCommit;
    private Boolean readOnly;
    private Integer transactionIsolation;
    private String catalog;
    private String schema;

    public ConnectionPropertiesImpl() {
    }

    public ConnectionPropertiesImpl(Connection conn) throws SQLException {
        this(conn.getAutoCommit(), conn.isReadOnly(), conn.getTransactionIsolation(), conn.getCatalog(), conn.getSchema());
    }

    @JsonCreator
    public ConnectionPropertiesImpl(@JsonProperty(value="autoCommit") Boolean autoCommit, @JsonProperty(value="readOnly") Boolean readOnly, @JsonProperty(value="transactionIsolation") Integer transactionIsolation, @JsonProperty(value="catalog") String catalog, @JsonProperty(value="schema") String schema) {
        this.autoCommit = autoCommit;
        this.readOnly = readOnly;
        this.transactionIsolation = transactionIsolation;
        this.catalog = catalog;
        this.schema = schema;
    }

    public ConnectionPropertiesImpl setDirty(boolean val) {
        this.isDirty = val;
        return this;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    @Override
    public boolean isEmpty() {
        return this.autoCommit == null && this.readOnly == null && this.transactionIsolation == null && this.catalog == null && this.schema == null;
    }

    @Override
    public ConnectionPropertiesImpl merge(Meta.ConnectionProperties that) {
        if (this == that) {
            return this;
        }
        if (that.isAutoCommit() != null && this.autoCommit != that.isAutoCommit()) {
            this.autoCommit = that.isAutoCommit();
            this.isDirty = true;
        }
        if (that.isReadOnly() != null && this.readOnly != that.isReadOnly()) {
            this.readOnly = that.isReadOnly();
            this.isDirty = true;
        }
        if (that.getTransactionIsolation() != null && !that.getTransactionIsolation().equals(this.transactionIsolation)) {
            this.transactionIsolation = that.getTransactionIsolation();
            this.isDirty = true;
        }
        if (that.getCatalog() != null && !that.getCatalog().equalsIgnoreCase(this.catalog)) {
            this.catalog = that.getCatalog();
            this.isDirty = true;
        }
        if (that.getSchema() != null && !that.getSchema().equalsIgnoreCase(this.schema)) {
            this.schema = that.getSchema();
            this.isDirty = true;
        }
        return this;
    }

    @Override
    public Meta.ConnectionProperties setAutoCommit(boolean val) {
        this.autoCommit = val;
        this.isDirty = true;
        return this;
    }

    @Override
    public Boolean isAutoCommit() {
        return this.autoCommit;
    }

    @Override
    public Meta.ConnectionProperties setReadOnly(boolean val) {
        this.readOnly = val;
        this.isDirty = true;
        return this;
    }

    @Override
    public Boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public Meta.ConnectionProperties setTransactionIsolation(int val) {
        this.transactionIsolation = val;
        this.isDirty = true;
        return this;
    }

    @Override
    public Integer getTransactionIsolation() {
        return this.transactionIsolation;
    }

    @Override
    public Meta.ConnectionProperties setCatalog(String val) {
        this.catalog = val;
        this.isDirty = true;
        return this;
    }

    @Override
    public String getCatalog() {
        return this.catalog;
    }

    @Override
    public Meta.ConnectionProperties setSchema(String val) {
        this.schema = val;
        this.isDirty = true;
        return this;
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.autoCommit == null ? 0 : this.autoCommit.hashCode());
        result = 31 * result + (this.catalog == null ? 0 : this.catalog.hashCode());
        result = 31 * result + (this.isDirty ? 1231 : 1237);
        result = 31 * result + (this.readOnly == null ? 0 : this.readOnly.hashCode());
        result = 31 * result + (this.schema == null ? 0 : this.schema.hashCode());
        result = 31 * result + (this.transactionIsolation == null ? 0 : this.transactionIsolation.hashCode());
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ConnectionPropertiesImpl) {
            ConnectionPropertiesImpl other = (ConnectionPropertiesImpl)o;
            if (null == this.autoCommit ? null != other.autoCommit : !this.autoCommit.equals(other.autoCommit)) {
                return false;
            }
            if (null == this.catalog ? null != other.catalog : !this.catalog.equals(other.catalog)) {
                return false;
            }
            if (this.isDirty != other.isDirty) {
                return false;
            }
            if (null == this.readOnly ? null != other.readOnly : !this.readOnly.equals(other.readOnly)) {
                return false;
            }
            if (null == this.schema ? null != other.schema : !this.schema.equals(other.schema)) {
                return false;
            }
            return !(null == this.transactionIsolation ? null != other.transactionIsolation : !this.transactionIsolation.equals(other.transactionIsolation));
        }
        return false;
    }

    @Override
    public Common.ConnectionProperties toProto() {
        Common.ConnectionProperties.Builder builder = Common.ConnectionProperties.newBuilder();
        if (null != this.autoCommit) {
            builder.setHasAutoCommit(true);
            builder.setAutoCommit(this.autoCommit);
        } else {
            builder.setHasAutoCommit(false);
        }
        if (null != this.catalog) {
            builder.setCatalog(this.catalog);
        }
        builder.setIsDirty(this.isDirty);
        if (null != this.readOnly) {
            builder.setHasReadOnly(true);
            builder.setReadOnly(this.readOnly);
        } else {
            builder.setHasReadOnly(false);
        }
        if (null != this.schema) {
            builder.setSchema(this.schema);
        }
        if (null != this.transactionIsolation) {
            builder.setTransactionIsolation(this.transactionIsolation);
        }
        return builder.build();
    }

    public static ConnectionPropertiesImpl fromProto(Common.ConnectionProperties proto) {
        Descriptors.Descriptor desc = proto.getDescriptorForType();
        String catalog = null;
        if (ProtobufService.hasField(proto, desc, 5)) {
            catalog = proto.getCatalog();
        }
        String schema = null;
        if (ProtobufService.hasField(proto, desc, 6)) {
            schema = proto.getSchema();
        }
        Boolean autoCommit = null;
        if (proto.getHasAutoCommit()) {
            autoCommit = proto.getAutoCommit();
        }
        Boolean readOnly = null;
        if (proto.getHasReadOnly()) {
            readOnly = proto.getReadOnly();
        }
        Integer transactionIsolation = null;
        if (ProtobufService.hasField(proto, desc, 4)) {
            transactionIsolation = proto.getTransactionIsolation();
        }
        ConnectionPropertiesImpl impl = new ConnectionPropertiesImpl(autoCommit, readOnly, transactionIsolation, catalog, schema);
        impl.setDirty(proto.getIsDirty());
        return impl;
    }
}

