/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.remote;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.com.google.protobuf.ByteString;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.com.google.protobuf.Message;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.proto.Common;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.proto.Requests;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.proto.Responses;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.remote.ProtobufTranslation;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.remote.RequestTranslator;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.remote.ResponseTranslator;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.remote.Service;

public class ProtobufTranslationImpl
implements ProtobufTranslation {
    private static final Map<String, RequestTranslator> REQUEST_PARSERS;
    private static final Map<String, ResponseTranslator> RESPONSE_PARSERS;

    public static RequestTranslator getParserForRequest(String className) {
        if (null == className) {
            throw new IllegalArgumentException("Cannot fetch parser for null class name");
        }
        RequestTranslator translator = REQUEST_PARSERS.get(className);
        if (null == translator) {
            throw new IllegalArgumentException("Cannot find parser for " + className);
        }
        return translator;
    }

    public static ResponseTranslator getParserForResponse(String className) {
        if (null == className) {
            throw new IllegalArgumentException("Cannot fetch parser for null class name");
        }
        ResponseTranslator translator = RESPONSE_PARSERS.get(className);
        if (null == translator) {
            throw new IllegalArgumentException("Cannot find parser for " + className);
        }
        return translator;
    }

    @Override
    public byte[] serializeResponse(Service.Response response) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Message responseMsg = response.serialize();
        this.serializeMessage(out, responseMsg);
        return out.toByteArray();
    }

    @Override
    public byte[] serializeRequest(Service.Request request) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Message requestMsg = request.serialize();
        this.serializeMessage(out, requestMsg);
        return out.toByteArray();
    }

    void serializeMessage(OutputStream out, Message msg) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        msg.writeTo(baos);
        Common.WireMessage wireMsg = Common.WireMessage.newBuilder().setName(msg.getClass().getName()).setWrappedMessage(ByteString.copyFrom(baos.toByteArray())).build();
        wireMsg.writeTo(out);
    }

    @Override
    public Service.Request parseRequest(byte[] bytes) throws InvalidProtocolBufferException {
        Common.WireMessage wireMsg = Common.WireMessage.parseFrom(bytes);
        String serializedMessageClassName = wireMsg.getName();
        RequestTranslator translator = ProtobufTranslationImpl.getParserForRequest(serializedMessageClassName);
        return translator.transform(wireMsg.getWrappedMessage());
    }

    @Override
    public Service.Response parseResponse(byte[] bytes) throws InvalidProtocolBufferException {
        Common.WireMessage wireMsg = Common.WireMessage.parseFrom(bytes);
        String serializedMessageClassName = wireMsg.getName();
        ResponseTranslator translator = ProtobufTranslationImpl.getParserForResponse(serializedMessageClassName);
        return translator.transform(wireMsg.getWrappedMessage());
    }

    static {
        HashMap<String, RequestTranslator> reqParsers = new HashMap<String, RequestTranslator>();
        reqParsers.put(Requests.CatalogsRequest.class.getName(), new RequestTranslator(Requests.CatalogsRequest.parser(), new Service.CatalogsRequest()));
        reqParsers.put(Requests.OpenConnectionRequest.class.getName(), new RequestTranslator(Requests.OpenConnectionRequest.parser(), new Service.OpenConnectionRequest()));
        reqParsers.put(Requests.CloseConnectionRequest.class.getName(), new RequestTranslator(Requests.CloseConnectionRequest.parser(), new Service.CloseConnectionRequest()));
        reqParsers.put(Requests.CloseStatementRequest.class.getName(), new RequestTranslator(Requests.CloseStatementRequest.parser(), new Service.CloseStatementRequest()));
        reqParsers.put(Requests.ColumnsRequest.class.getName(), new RequestTranslator(Requests.ColumnsRequest.parser(), new Service.ColumnsRequest()));
        reqParsers.put(Requests.ConnectionSyncRequest.class.getName(), new RequestTranslator(Requests.ConnectionSyncRequest.parser(), new Service.ConnectionSyncRequest()));
        reqParsers.put(Requests.CreateStatementRequest.class.getName(), new RequestTranslator(Requests.CreateStatementRequest.parser(), new Service.CreateStatementRequest()));
        reqParsers.put(Requests.DatabasePropertyRequest.class.getName(), new RequestTranslator(Requests.DatabasePropertyRequest.parser(), new Service.DatabasePropertyRequest()));
        reqParsers.put(Requests.FetchRequest.class.getName(), new RequestTranslator(Requests.FetchRequest.parser(), new Service.FetchRequest()));
        reqParsers.put(Requests.PrepareAndExecuteRequest.class.getName(), new RequestTranslator(Requests.PrepareAndExecuteRequest.parser(), new Service.PrepareAndExecuteRequest()));
        reqParsers.put(Requests.PrepareRequest.class.getName(), new RequestTranslator(Requests.PrepareRequest.parser(), new Service.PrepareRequest()));
        reqParsers.put(Requests.SchemasRequest.class.getName(), new RequestTranslator(Requests.SchemasRequest.parser(), new Service.SchemasRequest()));
        reqParsers.put(Requests.TablesRequest.class.getName(), new RequestTranslator(Requests.TablesRequest.parser(), new Service.TablesRequest()));
        reqParsers.put(Requests.TableTypesRequest.class.getName(), new RequestTranslator(Requests.TableTypesRequest.parser(), new Service.TableTypesRequest()));
        reqParsers.put(Requests.TypeInfoRequest.class.getName(), new RequestTranslator(Requests.TypeInfoRequest.parser(), new Service.TypeInfoRequest()));
        reqParsers.put(Requests.ExecuteRequest.class.getName(), new RequestTranslator(Requests.ExecuteRequest.parser(), new Service.ExecuteRequest()));
        reqParsers.put(Requests.SyncResultsRequest.class.getName(), new RequestTranslator(Requests.SyncResultsRequest.parser(), new Service.SyncResultsRequest()));
        reqParsers.put(Requests.CommitRequest.class.getName(), new RequestTranslator(Requests.CommitRequest.parser(), new Service.CommitRequest()));
        reqParsers.put(Requests.RollbackRequest.class.getName(), new RequestTranslator(Requests.RollbackRequest.parser(), new Service.RollbackRequest()));
        REQUEST_PARSERS = Collections.unmodifiableMap(reqParsers);
        HashMap<String, ResponseTranslator> respParsers = new HashMap<String, ResponseTranslator>();
        respParsers.put(Responses.OpenConnectionResponse.class.getName(), new ResponseTranslator(Responses.OpenConnectionResponse.parser(), new Service.OpenConnectionResponse()));
        respParsers.put(Responses.CloseConnectionResponse.class.getName(), new ResponseTranslator(Responses.CloseConnectionResponse.parser(), new Service.CloseConnectionResponse()));
        respParsers.put(Responses.CloseStatementResponse.class.getName(), new ResponseTranslator(Responses.CloseStatementResponse.parser(), new Service.CloseStatementResponse()));
        respParsers.put(Responses.ConnectionSyncResponse.class.getName(), new ResponseTranslator(Responses.ConnectionSyncResponse.parser(), new Service.ConnectionSyncResponse()));
        respParsers.put(Responses.CreateStatementResponse.class.getName(), new ResponseTranslator(Responses.CreateStatementResponse.parser(), new Service.CreateStatementResponse()));
        respParsers.put(Responses.DatabasePropertyResponse.class.getName(), new ResponseTranslator(Responses.DatabasePropertyResponse.parser(), new Service.DatabasePropertyResponse()));
        respParsers.put(Responses.ExecuteResponse.class.getName(), new ResponseTranslator(Responses.ExecuteResponse.parser(), new Service.ExecuteResponse()));
        respParsers.put(Responses.FetchResponse.class.getName(), new ResponseTranslator(Responses.FetchResponse.parser(), new Service.FetchResponse()));
        respParsers.put(Responses.PrepareResponse.class.getName(), new ResponseTranslator(Responses.PrepareResponse.parser(), new Service.PrepareResponse()));
        respParsers.put(Responses.ResultSetResponse.class.getName(), new ResponseTranslator(Responses.ResultSetResponse.parser(), new Service.ResultSetResponse()));
        respParsers.put(Responses.ErrorResponse.class.getName(), new ResponseTranslator(Responses.ErrorResponse.parser(), new Service.ErrorResponse()));
        respParsers.put(Responses.SyncResultsResponse.class.getName(), new ResponseTranslator(Responses.SyncResultsResponse.parser(), new Service.SyncResultsResponse()));
        respParsers.put(Responses.RpcMetadata.class.getName(), new ResponseTranslator(Responses.RpcMetadata.parser(), new Service.RpcMetadataResponse()));
        respParsers.put(Responses.CommitResponse.class.getName(), new ResponseTranslator(Responses.CommitResponse.parser(), new Service.CommitResponse()));
        respParsers.put(Responses.RollbackResponse.class.getName(), new ResponseTranslator(Responses.RollbackResponse.parser(), new Service.RollbackResponse()));
        RESPONSE_PARSERS = Collections.unmodifiableMap(respParsers);
    }
}

