/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.segment.table;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.TreeSet;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.infra.binder.segment.select.subquery.SubqueryTableContext;
import org.apache.shardingsphere.infra.binder.segment.select.subquery.engine.SubqueryTableContextEngine;
import org.apache.shardingsphere.infra.binder.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.metadata.schema.ShardingSphereSchema;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SubqueryTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.TableSegment;

public final class TablesContext {
    private final Collection<SimpleTableSegment> tables = new LinkedList<SimpleTableSegment>();
    private final Collection<String> tableNames = new HashSet<String>();
    private final Collection<String> schemaNames = new HashSet<String>();
    private final Map<String, Collection<SubqueryTableContext>> subqueryTables = new HashMap<String, Collection<SubqueryTableContext>>();

    public TablesContext(SimpleTableSegment tableSegment) {
        this(Collections.singletonList(tableSegment));
    }

    public TablesContext(Collection<SimpleTableSegment> tableSegments) {
        this(tableSegments, Collections.emptyMap());
    }

    public TablesContext(Collection<? extends TableSegment> tableSegments, Map<Integer, SelectStatementContext> subqueryContexts) {
        if (tableSegments.isEmpty()) {
            return;
        }
        for (TableSegment tableSegment : tableSegments) {
            if (tableSegment instanceof SimpleTableSegment) {
                SimpleTableSegment simpleTableSegment = (SimpleTableSegment)tableSegment;
                this.tables.add(simpleTableSegment);
                this.tableNames.add(simpleTableSegment.getTableName().getIdentifier().getValue());
                simpleTableSegment.getOwner().ifPresent(owner -> this.schemaNames.add(owner.getIdentifier().getValue()));
            }
            if (!(tableSegment instanceof SubqueryTableSegment)) continue;
            this.subqueryTables.putAll(this.createSubqueryTables(subqueryContexts, (SubqueryTableSegment)tableSegment));
        }
    }

    private Map<String, Collection<SubqueryTableContext>> createSubqueryTables(Map<Integer, SelectStatementContext> subqueryContexts, SubqueryTableSegment subqueryTable) {
        SelectStatementContext subqueryContext = subqueryContexts.get(subqueryTable.getSubquery().getStartIndex());
        Collection<SubqueryTableContext> subqueryTableContexts = new SubqueryTableContextEngine().createSubqueryTableContexts(subqueryContext, subqueryTable.getAlias().orElse(null));
        HashMap<String, Collection<SubqueryTableContext>> result = new HashMap<String, Collection<SubqueryTableContext>>();
        for (SubqueryTableContext subQuery : subqueryTableContexts) {
            if (null == subQuery.getAlias()) continue;
            result.computeIfAbsent(subQuery.getAlias(), unused -> new LinkedList()).add(subQuery);
        }
        return result;
    }

    public Collection<String> getTableNames() {
        return this.tableNames;
    }

    public Map<String, String> findTableName(Collection<ColumnProjection> columns, ShardingSphereSchema schema) {
        if (1 == this.tables.size()) {
            return this.findTableNameFromSingleTable(columns);
        }
        TreeMap<String, String> result = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        result.putAll(this.findTableNameFromSQL(columns));
        result.putAll(this.findTableNameFromMetaData(columns, schema));
        result.putAll(this.findTableNameFromSubquery(columns, result));
        return result;
    }

    private Map<String, String> findTableNameFromSubquery(Collection<ColumnProjection> columns, Map<String, String> ownerTableNames) {
        if (ownerTableNames.size() == columns.size() || this.subqueryTables.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(columns.size(), 1.0f);
        for (ColumnProjection each : columns) {
            if (ownerTableNames.containsKey(each.getExpression())) continue;
            Collection subqueryTableContexts = this.subqueryTables.getOrDefault(each.getOwner(), Collections.emptyList());
            for (SubqueryTableContext subqueryTableContext : subqueryTableContexts) {
                if (!subqueryTableContext.getColumnNames().contains(each.getName())) continue;
                result.put(each.getExpression(), subqueryTableContext.getTableName());
            }
        }
        return result;
    }

    private Map<String, String> findTableNameFromSingleTable(Collection<ColumnProjection> columns) {
        String tableName = this.tables.iterator().next().getTableName().getIdentifier().getValue();
        TreeMap<String, String> result = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (ColumnProjection each : columns) {
            result.putIfAbsent(each.getExpression(), tableName);
        }
        return result;
    }

    private Map<String, Collection<String>> getOwnerColumnNames(Collection<ColumnProjection> columns) {
        TreeMap<String, Collection<String>> result = new TreeMap<String, Collection<String>>(String.CASE_INSENSITIVE_ORDER);
        for (ColumnProjection each : columns) {
            if (null == each.getOwner()) continue;
            Collection columnExpressions = result.getOrDefault(each.getOwner(), new LinkedList());
            columnExpressions.add(each.getExpression());
            result.put(each.getOwner(), columnExpressions);
        }
        return result;
    }

    private Map<String, String> findTableNameFromSQL(Collection<ColumnProjection> columns) {
        Map<String, Collection<String>> ownerColumnNames = this.getOwnerColumnNames(columns);
        if (ownerColumnNames.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(columns.size(), 1.0f);
        for (SimpleTableSegment each : this.tables) {
            Optional alias;
            String tableName = each.getTableName().getIdentifier().getValue();
            if (ownerColumnNames.containsKey(tableName)) {
                ownerColumnNames.get(tableName).forEach(column -> result.put((String)column, tableName));
            }
            if (!(alias = each.getAlias()).isPresent() || !ownerColumnNames.containsKey(alias.get())) continue;
            ownerColumnNames.get(alias.get()).forEach(column -> result.put((String)column, tableName));
        }
        return result;
    }

    private Map<String, String> findTableNameFromMetaData(Collection<ColumnProjection> columns, ShardingSphereSchema schema) {
        Collection<String> noOwnerColumnNames = this.getNoOwnerColumnNames(columns);
        if (noOwnerColumnNames.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(noOwnerColumnNames.size(), 1.0f);
        for (SimpleTableSegment each : this.tables) {
            String tableName = each.getTableName().getIdentifier().getValue();
            for (String columnName : schema.getAllColumnNames(tableName)) {
                if (!noOwnerColumnNames.contains(columnName)) continue;
                result.put(columnName, tableName);
            }
        }
        return result;
    }

    private Collection<String> getNoOwnerColumnNames(Collection<ColumnProjection> columns) {
        TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (ColumnProjection each : columns) {
            if (null != each.getOwner()) continue;
            result.add(each.getName());
        }
        return result;
    }

    public Optional<String> getSchemaName() {
        Preconditions.checkState((this.schemaNames.size() <= 1 ? 1 : 0) != 0, (Object)"Can not support multiple different schema.");
        Iterator<String> iterator = this.schemaNames.iterator();
        if (iterator.hasNext()) {
            String each = iterator.next();
            return Optional.of(each);
        }
        return Optional.empty();
    }

    @Generated
    public Collection<SimpleTableSegment> getTables() {
        return this.tables;
    }

    @Generated
    public Collection<String> getSchemaNames() {
        return this.schemaNames;
    }

    @Generated
    public Map<String, Collection<SubqueryTableContext>> getSubqueryTables() {
        return this.subqueryTables;
    }

    @Generated
    public String toString() {
        return "TablesContext(tables=" + this.getTables() + ", tableNames=" + this.getTableNames() + ", schemaNames=" + this.getSchemaNames() + ", subqueryTables=" + this.getSubqueryTables() + ")";
    }
}

