/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.instance;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.mode.ModeConfiguration;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstance;
import org.apache.shardingsphere.infra.instance.workerid.WorkerIdGenerator;
import org.apache.shardingsphere.infra.state.StateContext;
import org.apache.shardingsphere.infra.state.StateType;

public final class InstanceContext {
    private final ComputeNodeInstance instance;
    private final StateContext state = new StateContext();
    private final WorkerIdGenerator workerIdGenerator;
    private final ModeConfiguration modeConfiguration;

    public InstanceContext(ComputeNodeInstance instance, WorkerIdGenerator workerIdGenerator, ModeConfiguration modeConfiguration) {
        this.instance = instance;
        this.switchInstanceState(instance.getStatus());
        this.workerIdGenerator = workerIdGenerator;
        this.modeConfiguration = modeConfiguration;
    }

    public void updateInstanceStatus(Collection<String> status) {
        this.instance.setStatus(status);
        this.switchInstanceState(status);
    }

    private void switchInstanceState(Collection<String> status) {
        this.state.switchState(StateType.CIRCUIT_BREAK, null != status && status.contains(StateType.CIRCUIT_BREAK.name()));
    }

    public void updateWorkerId(Long workerId) {
        if (!Objects.equals(workerId, this.instance.getWorkerId())) {
            this.instance.setWorkerId(workerId);
        }
    }

    public void updateLabel(Collection<String> labels) {
        this.instance.setLabels(labels);
    }

    public long getWorkerId() {
        if (null == this.instance.getWorkerId()) {
            Optional.ofNullable(this.workerIdGenerator.generate()).ifPresent(this.instance::setWorkerId);
        }
        return this.instance.getWorkerId();
    }

    @Generated
    public ComputeNodeInstance getInstance() {
        return this.instance;
    }

    @Generated
    public StateContext getState() {
        return this.state;
    }

    @Generated
    public WorkerIdGenerator getWorkerIdGenerator() {
        return this.workerIdGenerator;
    }

    @Generated
    public ModeConfiguration getModeConfiguration() {
        return this.modeConfiguration;
    }
}

