/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.util.directory;

import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import java.util.zip.ZipEntry;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClasspathResourceDirectoryReader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClasspathResourceDirectoryReader.class);
    private static final Collection<String> JAR_URL_PROTOCOLS = new HashSet<String>(Arrays.asList("jar", "war", "zip", "wsjar", "vfszip"));

    public static boolean isDirectory(String name) {
        return ClasspathResourceDirectoryReader.isDirectory(Thread.currentThread().getContextClassLoader(), name);
    }

    public static boolean isDirectory(ClassLoader classLoader, String name) {
        URL resourceUrl = classLoader.getResource(name);
        if (null == resourceUrl) {
            return false;
        }
        if (JAR_URL_PROTOCOLS.contains(resourceUrl.getProtocol())) {
            JarFile jarFile = ClasspathResourceDirectoryReader.getJarFile(resourceUrl);
            return null != jarFile && jarFile.getJarEntry(name).isDirectory();
        }
        return Paths.get(resourceUrl.toURI()).toFile().isDirectory();
    }

    public static Stream<String> read(String directory) {
        return ClasspathResourceDirectoryReader.read(Thread.currentThread().getContextClassLoader(), directory);
    }

    public static Stream<String> read(ClassLoader classLoader, String directory) {
        Enumeration<URL> directoryUrlEnumeration = classLoader.getResources(directory);
        return Collections.list(directoryUrlEnumeration).stream().flatMap(directoryUrl -> {
            if (JAR_URL_PROTOCOLS.contains(directoryUrl.getProtocol())) {
                return ClasspathResourceDirectoryReader.readDirectoryInJar(directory, directoryUrl);
            }
            return ClasspathResourceDirectoryReader.readDirectoryInFileSystem(directory, directoryUrl);
        });
    }

    private static Stream<String> readDirectoryInJar(String directory, URL directoryUrl) {
        JarFile jar = ClasspathResourceDirectoryReader.getJarFile(directoryUrl);
        if (null == jar) {
            return Stream.empty();
        }
        return ClasspathResourceDirectoryReader.getJarEntryStream(jar).filter(each -> each.getName().startsWith(directory) && !each.isDirectory()).map(ZipEntry::getName);
    }

    private static Stream<JarEntry> getJarEntryStream(JarFile jar) {
        final Enumeration<JarEntry> entries = jar.entries();
        return StreamSupport.stream(Spliterators.spliterator(new Iterator<JarEntry>(){

            @Override
            public boolean hasNext() {
                return entries.hasMoreElements();
            }

            @Override
            public JarEntry next() {
                return (JarEntry)entries.nextElement();
            }
        }, (long)jar.size(), 1297), false);
    }

    private static JarFile getJarFile(URL url) {
        URLConnection urlConnection;
        URL jarUrl = url;
        if ("zip".equals(url.getProtocol())) {
            jarUrl = new URL(url.toExternalForm().replace("zip:/", "jar:file:/"));
        }
        if (!((urlConnection = jarUrl.openConnection()) instanceof JarURLConnection)) {
            return null;
        }
        return ((JarURLConnection)urlConnection).getJarFile();
    }

    private static Stream<String> readDirectoryInFileSystem(String directory, URL directoryUrl) {
        try {
            return ClasspathResourceDirectoryReader.loadFromDirectory(directory, directoryUrl);
        }
        catch (FileSystemNotFoundException ignore) {
            FileSystem fileSystem = FileSystems.newFileSystem(directoryUrl.toURI(), Collections.emptyMap());
            return (Stream)ClasspathResourceDirectoryReader.loadFromDirectory(directory, directoryUrl).onClose(() -> {
                try {
                    fileSystem.close();
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            });
        }
    }

    private static Stream<String> loadFromDirectory(String directory, URL directoryUrl) throws URISyntaxException, IOException {
        Path directoryPath = Paths.get(directoryUrl.toURI());
        Stream<Path> walkStream = Files.find(directoryPath, Integer.MAX_VALUE, (path, basicFileAttributes) -> !basicFileAttributes.isDirectory(), FileVisitOption.FOLLOW_LINKS);
        return walkStream.map(path -> {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(directory);
            for (Path each : path.subpath(directoryPath.getNameCount(), path.getNameCount())) {
                stringBuilder.append("/");
                stringBuilder.append(each);
            }
            return stringBuilder.toString();
        });
    }

    @Generated
    private ClasspathResourceDirectoryReader() {
    }
}

