/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.node.path.metadata;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

public final class ViewMetaDataNodePath {
    private static final String ROOT_NODE = "/metadata";
    private static final String SCHEMAS_NODE = "schemas";
    private static final String VIEWS_NODE = "views";
    private static final String VERSIONS_NODE = "versions";
    private static final String ACTIVE_VERSION_NODE = "active_version";
    private static final String VIEWS_PATTERN = "/([\\w\\-]+)/schemas/([\\w\\-]+)/views";
    private static final String ACTIVE_VERSION_SUFFIX = "/([\\w\\-]+)/active_version";
    private static final String VIEW_SUFFIX = "/([\\w\\-]+)$";

    public static String getMetaDataViewsPath(String databaseName, String schemaName) {
        return String.join((CharSequence)"/", ROOT_NODE, databaseName, SCHEMAS_NODE, schemaName, VIEWS_NODE);
    }

    public static String getViewActiveVersionPath(String databaseName, String schemaName, String viewName) {
        return String.join((CharSequence)"/", ROOT_NODE, databaseName, SCHEMAS_NODE, schemaName, VIEWS_NODE, viewName, ACTIVE_VERSION_NODE);
    }

    public static String getViewVersionsPath(String databaseName, String schemaName, String viewName) {
        return String.join((CharSequence)"/", ROOT_NODE, databaseName, SCHEMAS_NODE, schemaName, VIEWS_NODE, viewName, VERSIONS_NODE);
    }

    public static String getViewVersionPath(String databaseName, String schemaName, String viewName, String version) {
        return String.join((CharSequence)"/", ViewMetaDataNodePath.getViewVersionsPath(databaseName, schemaName, viewName), version);
    }

    public static String getViewPath(String databaseName, String schemaName, String viewName) {
        return String.join((CharSequence)"/", ROOT_NODE, databaseName, SCHEMAS_NODE, schemaName, VIEWS_NODE, viewName);
    }

    public static Optional<String> getViewNameByActiveVersionPath(String path) {
        Pattern pattern = Pattern.compile("/metadata/([\\w\\-]+)/schemas/([\\w\\-]+)/views/([\\w\\-]+)/active_version", 2);
        Matcher matcher = pattern.matcher(path);
        return matcher.find() ? Optional.of(matcher.group(3)) : Optional.empty();
    }

    public static Optional<String> findViewName(String path) {
        Pattern pattern = Pattern.compile("/metadata/([\\w\\-]+)/schemas/([\\w\\-]+)/views/([\\w\\-]+)$", 2);
        Matcher matcher = pattern.matcher(path);
        return matcher.find() ? Optional.of(matcher.group(3)) : Optional.empty();
    }

    public static boolean isViewActiveVersionPath(String path) {
        return Pattern.compile("/metadata/([\\w\\-]+)/schemas/([\\w\\-]+)/views/([\\w\\-]+)/active_version", 2).matcher(path).find();
    }

    public static boolean isViewPath(String path) {
        return Pattern.compile("/metadata/([\\w\\-]+)/schemas/([\\w\\-]+)/views/([\\w\\-]+)$", 2).matcher(path).find();
    }

    @Generated
    private ViewMetaDataNodePath() {
    }
}

