/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.update;

import com.google.common.base.Splitter;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.distsql.exception.rule.RequiredRuleMissedException;
import org.apache.shardingsphere.infra.distsql.exception.rule.RuleDefinitionViolationException;
import org.apache.shardingsphere.infra.distsql.exception.rule.RuleInUsedException;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionDropUpdater;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingAutoTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableRuleConfiguration;
import org.apache.shardingsphere.sharding.distsql.parser.statement.DropShardingTableRuleStatement;

public final class DropShardingTableRuleStatementUpdater
implements RuleDefinitionDropUpdater<DropShardingTableRuleStatement, ShardingRuleConfiguration> {
    public void checkSQLStatement(ShardingSphereMetaData shardingSphereMetaData, DropShardingTableRuleStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) throws RuleDefinitionViolationException {
        String schemaName = shardingSphereMetaData.getName();
        this.checkCurrentRuleConfiguration(schemaName, currentRuleConfig);
        this.checkToBeDroppedShardingTableNames(schemaName, sqlStatement, currentRuleConfig);
        this.checkBindingTables(schemaName, sqlStatement, currentRuleConfig);
    }

    private void checkCurrentRuleConfiguration(String schemaName, ShardingRuleConfiguration currentRuleConfig) throws RequiredRuleMissedException {
        if (null == currentRuleConfig) {
            throw new RequiredRuleMissedException("Sharding", schemaName);
        }
    }

    private Collection<String> getToBeDroppedShardingTableNames(DropShardingTableRuleStatement sqlStatement) {
        return sqlStatement.getTableNames().stream().map(each -> each.getIdentifier().getValue()).collect(Collectors.toList());
    }

    private void checkToBeDroppedShardingTableNames(String schemaName, DropShardingTableRuleStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) throws RequiredRuleMissedException {
        Collection<String> currentShardingTableNames = this.getCurrentShardingTableNames(currentRuleConfig);
        Collection notExistedTableNames = this.getToBeDroppedShardingTableNames(sqlStatement).stream().filter(each -> !currentShardingTableNames.contains(each)).collect(Collectors.toList());
        if (!notExistedTableNames.isEmpty()) {
            throw new RequiredRuleMissedException("sharding", schemaName, notExistedTableNames);
        }
    }

    private Collection<String> getCurrentShardingTableNames(ShardingRuleConfiguration shardingRuleConfig) {
        LinkedList<String> result = new LinkedList<String>();
        result.addAll(shardingRuleConfig.getTables().stream().map(ShardingTableRuleConfiguration::getLogicTable).collect(Collectors.toList()));
        result.addAll(shardingRuleConfig.getAutoTables().stream().map(ShardingAutoTableRuleConfiguration::getLogicTable).collect(Collectors.toList()));
        return result;
    }

    private void checkBindingTables(String schemaName, DropShardingTableRuleStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) throws RuleInUsedException {
        Collection<String> bindingTables = this.getBindingTables(currentRuleConfig);
        Collection usedTableNames = this.getToBeDroppedShardingTableNames(sqlStatement).stream().filter(bindingTables::contains).collect(Collectors.toList());
        if (!usedTableNames.isEmpty()) {
            throw new RuleInUsedException("Sharding", schemaName, usedTableNames);
        }
    }

    private Collection<String> getBindingTables(ShardingRuleConfiguration shardingRuleConfig) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        shardingRuleConfig.getBindingTableGroups().forEach(each -> result.addAll(Splitter.on((String)",").splitToList((CharSequence)each)));
        return result;
    }

    public boolean updateCurrentRuleConfiguration(DropShardingTableRuleStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) {
        for (String each : this.getToBeDroppedShardingTableNames(sqlStatement)) {
            this.dropShardingTable(currentRuleConfig, each);
        }
        return false;
    }

    private void dropShardingTable(ShardingRuleConfiguration currentRuleConfig, String tableName) {
        currentRuleConfig.getTables().removeAll(currentRuleConfig.getTables().stream().filter(each -> tableName.equalsIgnoreCase(each.getLogicTable())).collect(Collectors.toList()));
        currentRuleConfig.getAutoTables().removeAll(currentRuleConfig.getAutoTables().stream().filter(each -> tableName.equalsIgnoreCase(each.getLogicTable())).collect(Collectors.toList()));
    }

    public Class<ShardingRuleConfiguration> getRuleConfigurationClass() {
        return ShardingRuleConfiguration.class;
    }

    public String getType() {
        return DropShardingTableRuleStatement.class.getName();
    }
}

