/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.spi.singleton;

import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.spi.singleton.SingletonSPI;
import org.apache.shardingsphere.spi.typed.TypedSPI;

public final class SingletonSPIRegistry {
    public static <K, T extends SingletonSPI> Map<K, T> getSingletonInstancesMap(Class<T> singletonSPIClass, Function<? super T, ? extends K> keyMapper) {
        ShardingSphereServiceLoader.register(singletonSPIClass);
        Collection<T> instances = ShardingSphereServiceLoader.getSingletonServiceInstances(singletonSPIClass);
        return instances.stream().collect(Collectors.toMap(keyMapper, Function.identity()));
    }

    public static <T extends TypedSPI & SingletonSPI> Map<String, T> getTypedSingletonInstancesMap(Class<T> singletonSPIClass) {
        return SingletonSPIRegistry.getSingletonInstancesMap(singletonSPIClass, TypedSPI::getType);
    }

    @Generated
    private SingletonSPIRegistry() {
    }
}

