/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.optimizer.statement;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.api.CacheOption;
import org.apache.shardingsphere.sqlfederation.optimizer.statement.SQLStatementCompilerEngine;

public final class SQLStatementCompilerEngineFactory {
    private static final Map<String, SQLStatementCompilerEngine> COMPILER_ENGINES = new ConcurrentHashMap<String, SQLStatementCompilerEngine>(1, 1.0f);

    public static SQLStatementCompilerEngine getSQLStatementCompilerEngine(String databaseName, String schemaName, CacheOption cacheOption) {
        String cacheKey = databaseName + "." + schemaName;
        SQLStatementCompilerEngine result = COMPILER_ENGINES.get(cacheKey);
        if (null == result) {
            result = COMPILER_ENGINES.computeIfAbsent(cacheKey, unused -> new SQLStatementCompilerEngine(cacheOption));
        }
        return result;
    }

    @Generated
    private SQLStatementCompilerEngineFactory() {
    }
}

