/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.sql.predicate;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.PredicateSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.generic.table.SimpleTableSegment;

public final class PredicateExtractor {
    private final Collection<SimpleTableSegment> tables;
    private final PredicateSegment predicate;

    public Collection<SimpleTableSegment> extractTables() {
        OwnerSegment segment;
        LinkedList<SimpleTableSegment> result = new LinkedList<SimpleTableSegment>();
        if (this.isToGenerateTableTokenLeftValue()) {
            Preconditions.checkState((boolean)this.predicate.getColumn().getOwner().isPresent());
            segment = this.predicate.getColumn().getOwner().get();
            result.add(new SimpleTableSegment(segment.getStartIndex(), segment.getStopIndex(), segment.getIdentifier()));
        }
        if (this.isToGenerateTableTokenForRightValue()) {
            Preconditions.checkState((boolean)((ColumnSegment)this.predicate.getRightValue()).getOwner().isPresent());
            segment = ((ColumnSegment)this.predicate.getRightValue()).getOwner().get();
            result.add(new SimpleTableSegment(segment.getStartIndex(), segment.getStopIndex(), segment.getIdentifier()));
        }
        return result;
    }

    private boolean isToGenerateTableTokenLeftValue() {
        return this.predicate.getColumn().getOwner().isPresent() && this.isTable(this.predicate.getColumn().getOwner().get());
    }

    private boolean isToGenerateTableTokenForRightValue() {
        return this.predicate.getRightValue() instanceof ColumnSegment && ((ColumnSegment)this.predicate.getRightValue()).getOwner().isPresent() && this.isTable(((ColumnSegment)this.predicate.getRightValue()).getOwner().get());
    }

    private boolean isTable(OwnerSegment owner) {
        for (SimpleTableSegment each : this.tables) {
            if (!owner.getIdentifier().getValue().equals(each.getAlias().orElse(null))) continue;
            return false;
        }
        return true;
    }

    @Generated
    public PredicateExtractor(Collection<SimpleTableSegment> tables, PredicateSegment predicate) {
        this.tables = tables;
        this.predicate = predicate;
    }
}

