/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.sql.statement.dml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.assignment.AssignmentSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.assignment.InsertValuesSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.assignment.SetAssignmentSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.column.InsertColumnsSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.column.OnDuplicateKeyColumnsSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.statement.dml.DMLStatement;

public final class InsertStatement
extends DMLStatement {
    private SimpleTableSegment table;
    private InsertColumnsSegment insertColumns;
    private SetAssignmentSegment setAssignment;
    private OnDuplicateKeyColumnsSegment onDuplicateKeyColumns;
    private final Collection<InsertValuesSegment> values = new LinkedList<InsertValuesSegment>();

    public Optional<InsertColumnsSegment> getInsertColumns() {
        return Optional.ofNullable(this.insertColumns);
    }

    public Collection<ColumnSegment> getColumns() {
        return null == this.insertColumns ? Collections.emptyList() : this.insertColumns.getColumns();
    }

    public Optional<SetAssignmentSegment> getSetAssignment() {
        return Optional.ofNullable(this.setAssignment);
    }

    public Optional<OnDuplicateKeyColumnsSegment> getOnDuplicateKeyColumns() {
        return Optional.ofNullable(this.onDuplicateKeyColumns);
    }

    public boolean useDefaultColumns() {
        return this.getColumns().isEmpty() && null == this.setAssignment;
    }

    public List<String> getColumnNames() {
        return null == this.setAssignment ? this.getColumnNamesForInsertColumns() : this.getColumnNamesForSetAssignment();
    }

    private List<String> getColumnNamesForInsertColumns() {
        LinkedList<String> result = new LinkedList<String>();
        for (ColumnSegment each : this.getColumns()) {
            result.add(each.getIdentifier().getValue().toLowerCase());
        }
        return result;
    }

    private List<String> getColumnNamesForSetAssignment() {
        LinkedList<String> result = new LinkedList<String>();
        for (AssignmentSegment each : this.setAssignment.getAssignments()) {
            result.add(each.getColumn().getIdentifier().getValue().toLowerCase());
        }
        return result;
    }

    public int getValueListCount() {
        return null == this.setAssignment ? this.values.size() : 1;
    }

    public int getValueCountForPerGroup() {
        if (!this.values.isEmpty()) {
            return this.values.iterator().next().getValues().size();
        }
        if (null != this.setAssignment) {
            return this.setAssignment.getAssignments().size();
        }
        return 0;
    }

    public List<List<ExpressionSegment>> getAllValueExpressions() {
        return null == this.setAssignment ? this.getAllValueExpressionsFromValues() : Collections.singletonList(this.getAllValueExpressionsFromSetAssignment());
    }

    private List<List<ExpressionSegment>> getAllValueExpressionsFromValues() {
        ArrayList<List<ExpressionSegment>> result = new ArrayList<List<ExpressionSegment>>(this.values.size());
        for (InsertValuesSegment each : this.values) {
            result.add(each.getValues());
        }
        return result;
    }

    private List<ExpressionSegment> getAllValueExpressionsFromSetAssignment() {
        ArrayList<ExpressionSegment> result = new ArrayList<ExpressionSegment>(this.setAssignment.getAssignments().size());
        for (AssignmentSegment each : this.setAssignment.getAssignments()) {
            result.add(each.getValue());
        }
        return result;
    }

    @Generated
    public SimpleTableSegment getTable() {
        return this.table;
    }

    @Generated
    public Collection<InsertValuesSegment> getValues() {
        return this.values;
    }

    @Generated
    public void setTable(SimpleTableSegment table) {
        this.table = table;
    }

    @Generated
    public void setInsertColumns(InsertColumnsSegment insertColumns) {
        this.insertColumns = insertColumns;
    }

    @Generated
    public void setSetAssignment(SetAssignmentSegment setAssignment) {
        this.setAssignment = setAssignment;
    }

    @Generated
    public void setOnDuplicateKeyColumns(OnDuplicateKeyColumnsSegment onDuplicateKeyColumns) {
        this.onDuplicateKeyColumns = onDuplicateKeyColumns;
    }
}

