/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.sql.common.util;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.sql.common.constant.SubqueryType;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BetweenExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExistsSubqueryExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.InExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ListExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.subquery.SubqueryExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.subquery.SubquerySegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionsSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.SubqueryProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.JoinTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SubqueryTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.TableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;

public final class SubqueryExtractUtil {
    public static Collection<SubquerySegment> getSubquerySegments(SelectStatement selectStatement) {
        LinkedList<SubquerySegment> result = new LinkedList<SubquerySegment>();
        result.addAll(SubqueryExtractUtil.getSubquerySegmentsFromProjections(selectStatement.getProjections()));
        result.addAll(SubqueryExtractUtil.getSubquerySegmentsFromTableSegment(selectStatement.getFrom()));
        if (selectStatement.getWhere().isPresent()) {
            result.addAll(SubqueryExtractUtil.getSubquerySegmentsFromExpression(selectStatement.getWhere().get().getExpr()));
        }
        return result;
    }

    private static Collection<SubquerySegment> getSubquerySegmentsFromProjections(ProjectionsSegment projections) {
        if (null == projections || projections.getProjections().isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<SubquerySegment> result = new LinkedList<SubquerySegment>();
        for (ProjectionSegment each : projections.getProjections()) {
            if (!(each instanceof SubqueryProjectionSegment)) continue;
            SubquerySegment subquery = ((SubqueryProjectionSegment)each).getSubquery();
            subquery.setSubqueryType(SubqueryType.PROJECTION_SUBQUERY);
            result.add(subquery);
            result.addAll(SubqueryExtractUtil.getSubquerySegments(subquery.getSelect()));
        }
        return result;
    }

    private static Collection<SubquerySegment> getSubquerySegmentsFromTableSegment(TableSegment tableSegment) {
        if (null == tableSegment) {
            return Collections.emptyList();
        }
        LinkedList<SubquerySegment> result = new LinkedList<SubquerySegment>();
        if (tableSegment instanceof SubqueryTableSegment) {
            SubquerySegment subquery = ((SubqueryTableSegment)tableSegment).getSubquery();
            subquery.setSubqueryType(SubqueryType.TABLE_SUBQUERY);
            result.add(subquery);
            result.addAll(SubqueryExtractUtil.getSubquerySegments(subquery.getSelect()));
        }
        if (tableSegment instanceof JoinTableSegment) {
            result.addAll(SubqueryExtractUtil.getSubquerySegmentsFromTableSegment(((JoinTableSegment)tableSegment).getLeft()));
            result.addAll(SubqueryExtractUtil.getSubquerySegmentsFromTableSegment(((JoinTableSegment)tableSegment).getRight()));
        }
        return result;
    }

    private static Collection<SubquerySegment> getSubquerySegmentsFromExpression(ExpressionSegment expressionSegment) {
        Object subquery;
        LinkedList<SubquerySegment> result = new LinkedList<SubquerySegment>();
        if (expressionSegment instanceof SubqueryExpressionSegment) {
            subquery = ((SubqueryExpressionSegment)expressionSegment).getSubquery();
            ((SubquerySegment)subquery).setSubqueryType(SubqueryType.PREDICATE_SUBQUERY);
            result.add((SubquerySegment)subquery);
            result.addAll(SubqueryExtractUtil.getSubquerySegments(((SubquerySegment)subquery).getSelect()));
        }
        if (expressionSegment instanceof ListExpression) {
            for (ExpressionSegment each : ((ListExpression)expressionSegment).getItems()) {
                result.addAll(SubqueryExtractUtil.getSubquerySegmentsFromExpression(each));
            }
        }
        if (expressionSegment instanceof BinaryOperationExpression) {
            result.addAll(SubqueryExtractUtil.getSubquerySegmentsFromExpression(((BinaryOperationExpression)expressionSegment).getLeft()));
            result.addAll(SubqueryExtractUtil.getSubquerySegmentsFromExpression(((BinaryOperationExpression)expressionSegment).getRight()));
        }
        if (expressionSegment instanceof InExpression) {
            result.addAll(SubqueryExtractUtil.getSubquerySegmentsFromExpression(((InExpression)expressionSegment).getLeft()));
            result.addAll(SubqueryExtractUtil.getSubquerySegmentsFromExpression(((InExpression)expressionSegment).getRight()));
        }
        if (expressionSegment instanceof BetweenExpression) {
            result.addAll(SubqueryExtractUtil.getSubquerySegmentsFromExpression(((BetweenExpression)expressionSegment).getBetweenExpr()));
            result.addAll(SubqueryExtractUtil.getSubquerySegmentsFromExpression(((BetweenExpression)expressionSegment).getAndExpr()));
        }
        if (expressionSegment instanceof ExistsSubqueryExpression) {
            subquery = ((ExistsSubqueryExpression)expressionSegment).getSubquery();
            ((SubquerySegment)subquery).setSubqueryType(SubqueryType.EXISTS_SUBQUERY);
            result.add((SubquerySegment)subquery);
            result.addAll(SubqueryExtractUtil.getSubquerySegments(((SubquerySegment)subquery).getSelect()));
        }
        return result;
    }

    @Generated
    private SubqueryExtractUtil() {
    }
}

