/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.exec;

import java.lang.module.Configuration;
import java.lang.module.ModuleFinder;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.mojo.exec.AbstractExecJavaBase;
import org.codehaus.plexus.PlexusContainer;
import org.eclipse.aether.RepositorySystem;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@Mojo(name="java", threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST)
public class ExecJavaMojo
extends AbstractExecJavaBase {
    @Inject
    protected ExecJavaMojo(RepositorySystem repositorySystem, PlexusContainer container) {
        super(repositorySystem, container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doExecModulePath(String moduleName, String bootClassName) throws Throwable {
        ArrayList<Path> modulePaths = new ArrayList<Path>();
        this.addRelevantPluginDependenciesToClasspath(modulePaths);
        this.addRelevantProjectDependenciesToClasspath(modulePaths);
        this.addAdditionalClasspathElements(modulePaths);
        this.getLog().debug((CharSequence)("Module paths for JPMS execution: " + String.valueOf(modulePaths)));
        ModuleFinder finder = ModuleFinder.of(modulePaths.toArray(new Path[0]));
        ModuleLayer parent = ModuleLayer.boot();
        Configuration cf = parent.configuration().resolveAndBind(finder, ModuleFinder.of(new Path[0]), Set.of(moduleName));
        this.getLog().debug((CharSequence)("Resolved modules: " + String.valueOf(cf.modules())));
        ModuleLayer.Controller controller = ModuleLayer.defineModulesWithOneLoader(cf, List.of(parent), ClassLoader.getSystemClassLoader());
        ModuleLayer layer = controller.layer();
        ClassLoader moduleLoader = layer.findLoader(moduleName);
        Class<?> bootClass = moduleLoader.loadClass(bootClassName);
        Module bootModule = bootClass.getModule();
        String packageName = bootClass.getPackageName();
        if (bootModule != null && bootModule.isNamed()) {
            controller.addOpens(bootModule, packageName, ((Object)((Object)this)).getClass().getModule());
            this.getLog().debug((CharSequence)("Opened package " + packageName + " in module " + bootModule.getName() + " for reflection"));
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader oldContextClassLoader = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(moduleLoader);
            this.executeMainMethodForModule(bootClass);
        }
        finally {
            currentThread.setContextClassLoader(oldContextClassLoader);
        }
    }

    private void executeMainMethodForModule(Class<?> bootClass) throws Throwable {
        try {
            Method mainMethod = bootClass.getDeclaredMethod("main", String[].class);
            if (!Modifier.isPublic(mainMethod.getModifiers()) || !Modifier.isStatic(mainMethod.getModifiers())) {
                throw new NoSuchMethodException("main method must be public and static in " + String.valueOf(bootClass));
            }
            mainMethod.setAccessible(true);
            mainMethod.invoke(null, new Object[]{this.arguments});
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodException("No static void main(String[] args) method found in " + String.valueOf(bootClass));
        }
    }

    @Override
    protected void executeMainMethod(Class<?> bootClass) throws Throwable {
        Module unnamedModule;
        String packageName;
        Module bootModule = bootClass.getModule();
        if (bootModule != null && bootModule.isNamed() && !bootModule.isOpen(packageName = bootClass.getPackageName(), unnamedModule = ((Object)((Object)this)).getClass().getModule())) {
            try {
                Method implAddOpensMethod = Module.class.getDeclaredMethod("implAddOpens", String.class);
                implAddOpensMethod.setAccessible(true);
                implAddOpensMethod.invoke((Object)bootModule, packageName);
                this.getLog().debug((CharSequence)("Opened package " + packageName + " in module " + bootModule.getName()));
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)("Could not open package " + packageName + " for reflection: " + e.getMessage()));
            }
        }
        super.executeMainMethod(bootClass);
    }
}

