/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser.xls;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.decisiontable.parser.RuleSheetParserUtil;
import org.drools.template.parser.DataListener;

public class PropertiesSheetListener
implements DataListener {
    private static final String EMPTY_STRING = "";
    private final Map<Integer, String[]> _rowProperties = new HashMap<Integer, String[]>();
    private final CaseInsensitiveMap _properties = new CaseInsensitiveMap();

    public CaseInsensitiveMap getProperties() {
        this.finishSheet();
        return this._properties;
    }

    public void startSheet(String name) {
    }

    public void finishSheet() {
        for (String[] keyValue : this._rowProperties.values()) {
            this._properties.addProperty(keyValue[0], new String[]{keyValue[1], keyValue[2]});
        }
        this._rowProperties.clear();
    }

    public void newRow(int rowNumber, int columns) {
    }

    public void newCell(int row, int column, String value, int mergedColStart) {
        if (this.emptyCellValue(value)) {
            return;
        }
        Integer rowInt = new Integer(row);
        if (this._rowProperties.containsKey(rowInt)) {
            String[] keyValue = this._rowProperties.get(rowInt);
            if (EMPTY_STRING.equals(keyValue[1])) {
                keyValue[1] = value;
                keyValue[2] = RuleSheetParserUtil.rc2name(row, column);
            }
        } else {
            String trimmedValue = value.trim();
            String[] keyValue = new String[]{trimmedValue, EMPTY_STRING, RuleSheetParserUtil.rc2name(row, column + 1)};
            this._rowProperties.put(rowInt, keyValue);
        }
    }

    private boolean emptyCellValue(String value) {
        return value == null || value.trim().equals(EMPTY_STRING);
    }

    public static class CaseInsensitiveMap
    extends HashMap<String, List<String[]>> {
        private List<String[]> getPropertyCell(String key) {
            return (List)super.get(key.toLowerCase());
        }

        public void addProperty(String key, String[] value) {
            List<String[]> r = this.getPropertyCell(key = key.toLowerCase());
            if (r == null) {
                r = new ArrayList<String[]>();
            }
            r.add(value);
            super.put(key, r);
        }

        private List<String> getList(String key, int index) {
            List<String[]> pcList = this.getPropertyCell(key);
            if (pcList == null) {
                return null;
            }
            ArrayList<String> r = new ArrayList<String>();
            for (String[] pc : pcList) {
                r.add(pc[index]);
            }
            return r;
        }

        public List<String> getProperty(String key) {
            return this.getList(key, 0);
        }

        public List<String> getPropertyCells(String key) {
            return this.getList(key, 1);
        }

        private String getSingle(String key, int index) {
            List<String[]> r = this.getPropertyCell(key);
            if (r == null || r.size() == 0) {
                return null;
            }
            return r.get(0)[index];
        }

        public String getSingleProperty(String key) {
            return this.getSingle(key, 0);
        }

        public String getSinglePropertyCell(String key) {
            return this.getSingle(key, 1);
        }

        public String getSingleProperty(String key, String defaultValue) {
            String r = this.getSingleProperty(key);
            if (r == null || PropertiesSheetListener.EMPTY_STRING.equals(r)) {
                r = defaultValue;
            }
            return r;
        }
    }
}

