/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.action;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.xpack.monitoring.action.MonitoringIndex;
import org.elasticsearch.xpack.monitoring.exporter.MonitoringDoc;

public class MonitoringBulkDoc
extends MonitoringDoc {
    private MonitoringIndex index = MonitoringIndex.TIMESTAMPED;
    private String type;
    private String id;
    private BytesReference source;
    private XContentType xContentType;

    public MonitoringBulkDoc(String monitoringId, String monitoringVersion) {
        super(monitoringId, monitoringVersion);
    }

    public MonitoringBulkDoc(String monitoringId, String monitoringVersion, MonitoringIndex index, String type, String id, BytesReference source, XContentType xContentType) {
        super(monitoringId, monitoringVersion);
        this.index = index;
        this.type = type;
        this.id = id;
        this.source = source;
        this.xContentType = xContentType;
    }

    public MonitoringBulkDoc(StreamInput in) throws IOException {
        super(in);
        this.index = MonitoringIndex.readFrom(in);
        this.type = in.readOptionalString();
        this.id = in.readOptionalString();
        this.source = in.readBytesReference();
        this.xContentType = this.source != BytesArray.EMPTY && in.getVersion().onOrAfter(Version.V_5_3_0_UNRELEASED) ? XContentType.readFrom((StreamInput)in) : XContentFactory.xContentType((BytesReference)this.source);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.index.writeTo(out);
        out.writeOptionalString(this.type);
        out.writeOptionalString(this.id);
        out.writeBytesReference(this.source);
        if (this.source != null && this.source != BytesArray.EMPTY && out.getVersion().onOrAfter(Version.V_5_3_0_UNRELEASED)) {
            this.xContentType.writeTo(out);
        }
    }

    public MonitoringIndex getIndex() {
        return this.index;
    }

    public void setIndex(MonitoringIndex index) {
        this.index = index;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public BytesReference getSource() {
        return this.source;
    }

    public void setSource(BytesReference source, XContentType xContentType) {
        this.source = source;
        this.xContentType = xContentType;
    }

    public XContentType getXContentType() {
        return this.xContentType;
    }
}

