/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.exporter.local;

import java.util.Arrays;
import java.util.Collection;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.xpack.monitoring.exporter.ExportBulk;
import org.elasticsearch.xpack.monitoring.exporter.ExportException;
import org.elasticsearch.xpack.monitoring.exporter.MonitoringDoc;
import org.elasticsearch.xpack.monitoring.resolver.MonitoringIndexNameResolver;
import org.elasticsearch.xpack.monitoring.resolver.ResolversRegistry;
import org.elasticsearch.xpack.security.InternalClient;

public class LocalBulk
extends ExportBulk {
    private final Logger logger;
    private final InternalClient client;
    private final ResolversRegistry resolvers;
    private final boolean usePipeline;
    private BulkRequestBuilder requestBuilder;

    public LocalBulk(String name, Logger logger, InternalClient client, ResolversRegistry resolvers, boolean usePipeline) {
        super(name, client.threadPool().getThreadContext());
        this.logger = logger;
        this.client = client;
        this.resolvers = resolvers;
        this.usePipeline = usePipeline;
    }

    @Override
    public void doAdd(Collection<MonitoringDoc> docs) throws ExportException {
        ExportException exception = null;
        for (MonitoringDoc doc : docs) {
            if (this.isClosed()) {
                return;
            }
            if (this.requestBuilder == null) {
                this.requestBuilder = this.client.prepareBulk();
            }
            try {
                MonitoringIndexNameResolver resolver = this.resolvers.getResolver(doc);
                IndexRequest request = new IndexRequest(resolver.index(doc), resolver.type(doc), resolver.id(doc));
                request.source(resolver.source(doc, XContentType.SMILE), XContentType.SMILE);
                if (this.usePipeline) {
                    request.setPipeline("xpack_monitoring_2");
                }
                this.requestBuilder.add(request);
                if (!this.logger.isTraceEnabled()) continue;
                this.logger.trace("local exporter [{}] - added index request [index={}, type={}, id={}, pipeline={}]", (Object)this.name, (Object)request.index(), (Object)request.type(), (Object)request.id(), (Object)request.getPipeline());
            }
            catch (Exception e) {
                if (exception == null) {
                    exception = new ExportException("failed to add documents to export bulk [{}]", this.name);
                }
                exception.addExportException(new ExportException("failed to add document [{}]", e, doc, this.name));
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    @Override
    public void doFlush(ActionListener<Void> listener) {
        if (this.requestBuilder == null || this.requestBuilder.numberOfActions() == 0 || this.isClosed()) {
            listener.onResponse(null);
        } else {
            try {
                this.logger.trace("exporter [{}] - exporting {} documents", (Object)this.name, (Object)this.requestBuilder.numberOfActions());
                this.requestBuilder.execute(ActionListener.wrap(bulkResponse -> {
                    if (bulkResponse.hasFailures()) {
                        this.throwExportException(bulkResponse.getItems(), listener);
                    } else {
                        listener.onResponse(null);
                    }
                }, e -> listener.onFailure((Exception)((Object)new ExportException("failed to flush export bulk [{}]", (Throwable)e, (Object)this.name)))));
            }
            finally {
                this.requestBuilder = null;
            }
        }
    }

    void throwExportException(BulkItemResponse[] bulkItemResponses, ActionListener<Void> listener) {
        ExportException exception = new ExportException("bulk [{}] reports failures when exporting documents", this.name);
        Arrays.stream(bulkItemResponses).filter(BulkItemResponse::isFailed).map(item -> new ExportException(item.getFailure().getCause())).forEach(exception::addExportException);
        if (exception.hasExportExceptions()) {
            for (ExportException e : exception) {
                this.logger.warn("unexpected error while indexing monitoring document", (Throwable)((Object)e));
            }
            listener.onFailure((Exception)((Object)exception));
        } else {
            listener.onResponse(null);
        }
    }

    @Override
    protected void doClose(ActionListener<Void> listener) {
        if (!this.isClosed()) {
            this.requestBuilder = null;
        }
        listener.onResponse(null);
    }
}

