/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.store;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.xpack.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.security.authz.permission.Role;
import org.elasticsearch.xpack.security.support.MetadataUtils;

public class ReservedRolesStore {
    public static final RoleDescriptor SUPERUSER_ROLE_DESCRIPTOR = new RoleDescriptor("superuser", new String[]{"all"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices("*").privileges("all").build()}, new String[]{"*"}, MetadataUtils.DEFAULT_RESERVED_METADATA);
    public static final Role SUPERUSER_ROLE = Role.builder(SUPERUSER_ROLE_DESCRIPTOR, null).build();
    private static final Map<String, RoleDescriptor> RESERVED_ROLES = ReservedRolesStore.initializeReservedRoles();

    private static Map<String, RoleDescriptor> initializeReservedRoles() {
        return MapBuilder.newMapBuilder().put((Object)"superuser", (Object)new RoleDescriptor("superuser", new String[]{"all"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices("*").privileges("all").build()}, new String[]{"*"}, MetadataUtils.DEFAULT_RESERVED_METADATA)).put((Object)"transport_client", (Object)new RoleDescriptor("transport_client", new String[]{"transport_client"}, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA)).put((Object)"kibana_user", (Object)new RoleDescriptor("kibana_user", new String[]{"monitor"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".kibana*").privileges("manage", "read", "index", "delete").build()}, null, MetadataUtils.DEFAULT_RESERVED_METADATA)).put((Object)"monitoring_user", (Object)new RoleDescriptor("monitoring_user", null, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".marvel-es-*", ".monitoring-*").privileges("read").build()}, null, MetadataUtils.DEFAULT_RESERVED_METADATA)).put((Object)"remote_monitoring_agent", (Object)new RoleDescriptor("remote_monitoring_agent", new String[]{"manage_index_templates", "manage_ingest_pipelines", "monitor"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".marvel-es-*", ".monitoring-*").privileges("all").build()}, null, MetadataUtils.DEFAULT_RESERVED_METADATA)).put((Object)"ingest_admin", (Object)new RoleDescriptor("ingest_admin", new String[]{"manage_index_templates", "manage_pipeline"}, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA)).put((Object)"reporting_user", (Object)new RoleDescriptor("reporting_user", null, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".reporting-*").privileges("read", "write").build()}, null, MetadataUtils.DEFAULT_RESERVED_METADATA)).put((Object)"kibana_system", (Object)new RoleDescriptor("kibana_system", new String[]{"monitor", "cluster:admin/xpack/monitoring/bulk"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".kibana*", ".reporting-*").privileges("all").build()}, null, MetadataUtils.DEFAULT_RESERVED_METADATA)).put((Object)"logstash_system", (Object)new RoleDescriptor("logstash_system", new String[]{"monitor", "cluster:admin/xpack/monitoring/bulk"}, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA)).immutableMap();
    }

    public Map<String, Object> usageStats() {
        return Collections.emptyMap();
    }

    public RoleDescriptor roleDescriptor(String role) {
        return RESERVED_ROLES.get(role);
    }

    public Collection<RoleDescriptor> roleDescriptors() {
        return RESERVED_ROLES.values();
    }

    public static Set<String> names() {
        return RESERVED_ROLES.keySet();
    }

    public static boolean isReserved(String role) {
        return RESERVED_ROLES.containsKey(role) || "_system".equals(role);
    }
}

