/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.user;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xpack.security.action.user.GetUsersResponse;
import org.elasticsearch.xpack.security.client.SecurityClient;
import org.elasticsearch.xpack.security.user.User;

public class RestGetUsersAction
extends BaseRestHandler {
    public RestGetUsersAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/_xpack/security/user/", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.GET, "/_xpack/security/user/{username}", (RestHandler)this);
        controller.registerAsDeprecatedHandler(RestRequest.Method.GET, "/_shield/user", (RestHandler)this, "[GET /_shield/user] is deprecated! Use [GET /_xpack/security/user] instead.", this.deprecationLogger);
        controller.registerAsDeprecatedHandler(RestRequest.Method.GET, "/_shield/user/{username}", (RestHandler)this, "[GET /_shield/user/{username}] is deprecated! Use [GET /_xpack/security/user/{username}] instead.", this.deprecationLogger);
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        final String[] usernames = request.paramAsStringArray("username", Strings.EMPTY_ARRAY);
        return channel -> new SecurityClient((ElasticsearchClient)client).prepareGetUsers(usernames).execute((ActionListener)new RestBuilderListener<GetUsersResponse>(channel){

            public RestResponse buildResponse(GetUsersResponse response, XContentBuilder builder) throws Exception {
                builder.startObject();
                for (User user : response.users()) {
                    builder.field(user.principal(), (ToXContent)user);
                }
                builder.endObject();
                if (usernames.length != 0 && response.users().length == 0) {
                    return new BytesRestResponse(RestStatus.NOT_FOUND, builder);
                }
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }
}

