/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.input.search;

import java.io.IOException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.ScriptSettings;
import org.elasticsearch.xpack.security.InternalClient;
import org.elasticsearch.xpack.watcher.input.InputFactory;
import org.elasticsearch.xpack.watcher.input.search.ExecutableSearchInput;
import org.elasticsearch.xpack.watcher.input.search.SearchInput;
import org.elasticsearch.xpack.watcher.input.simple.ExecutableSimpleInput;
import org.elasticsearch.xpack.watcher.support.init.proxy.WatcherClientProxy;
import org.elasticsearch.xpack.watcher.support.search.WatcherSearchTemplateService;

public class SearchInputFactory
extends InputFactory<SearchInput, SearchInput.Result, ExecutableSearchInput> {
    private final Settings settings;
    private final WatcherClientProxy client;
    private final TimeValue defaultTimeout;
    private final WatcherSearchTemplateService searchTemplateService;

    @Inject
    public SearchInputFactory(Settings settings, InternalClient client, NamedXContentRegistry xContentRegistry, ScriptService scriptService) {
        this(settings, new WatcherClientProxy(settings, client), xContentRegistry, scriptService);
    }

    public SearchInputFactory(Settings settings, WatcherClientProxy client, NamedXContentRegistry xContentRegistry, ScriptService scriptService) {
        super(Loggers.getLogger(ExecutableSimpleInput.class, (Settings)settings, (String[])new String[0]));
        this.settings = settings;
        this.client = client;
        this.defaultTimeout = settings.getAsTime("xpack.watcher.input.search.default_timeout", null);
        this.searchTemplateService = new WatcherSearchTemplateService(settings, scriptService, xContentRegistry);
    }

    @Override
    public String type() {
        return "search";
    }

    @Override
    public SearchInput parseInput(String watchId, XContentParser parser, boolean upgradeInputSource) throws IOException {
        String defaultLegacyScriptLanguage = ScriptSettings.getLegacyDefaultLang((Settings)this.settings);
        return SearchInput.parse(this.inputLogger, watchId, parser, upgradeInputSource, defaultLegacyScriptLanguage);
    }

    @Override
    public ExecutableSearchInput createExecutable(SearchInput input) {
        return new ExecutableSearchInput(input, this.inputLogger, this.client, this.searchTemplateService, this.defaultTimeout);
    }
}

