/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.transport.actions.get;

import java.io.IOException;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.watcher.WatcherService;
import org.elasticsearch.xpack.watcher.support.xcontent.WatcherParams;
import org.elasticsearch.xpack.watcher.transport.actions.WatcherTransportAction;
import org.elasticsearch.xpack.watcher.transport.actions.get.GetWatchRequest;
import org.elasticsearch.xpack.watcher.transport.actions.get.GetWatchResponse;
import org.elasticsearch.xpack.watcher.watch.Watch;

public class TransportGetWatchAction
extends WatcherTransportAction<GetWatchRequest, GetWatchResponse> {
    private final WatcherService watcherService;

    @Inject
    public TransportGetWatchAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, WatcherService watcherService, XPackLicenseState licenseState) {
        super(settings, "cluster:monitor/xpack/watcher/watch/get", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, licenseState, GetWatchRequest::new);
        this.watcherService = watcherService;
    }

    protected String executor() {
        return "same";
    }

    protected GetWatchResponse newResponse() {
        return new GetWatchResponse();
    }

    protected void masterOperation(GetWatchRequest request, ClusterState state, ActionListener<GetWatchResponse> listener) throws ElasticsearchException {
        if (!this.licenseState.isWatcherAllowed()) {
            listener.onFailure((Exception)((Object)LicenseUtils.newComplianceException("watcher")));
            return;
        }
        try {
            Watch watch = this.watcherService.getWatch(request.getId());
            if (watch == null) {
                listener.onResponse((Object)new GetWatchResponse(request.getId()));
                return;
            }
            try (XContentBuilder builder = XContentFactory.jsonBuilder();){
                watch.toXContent(builder, (ToXContent.Params)WatcherParams.builder().hideSecrets(true).build());
                BytesReference watchSource = builder.bytes();
                listener.onResponse((Object)new GetWatchResponse(watch.id(), watch.status(), watchSource, XContentType.JSON));
            }
            catch (IOException e) {
                listener.onFailure((Exception)e);
            }
        }
        catch (Exception e) {
            this.logger.error(() -> new ParameterizedMessage("failed to get watch [{}]", (Object)request.getId()), (Throwable)e);
            throw e;
        }
    }

    protected ClusterBlockException checkBlock(GetWatchRequest request, ClusterState state) {
        return state.blocks().indexBlockedException(ClusterBlockLevel.READ, ".watches");
    }
}

