/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.trigger;

import java.util.HashSet;
import java.util.Set;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.Binder;
import org.elasticsearch.common.inject.multibindings.Multibinder;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xpack.watcher.trigger.TriggerEngine;
import org.elasticsearch.xpack.watcher.trigger.TriggerService;
import org.elasticsearch.xpack.watcher.trigger.manual.ManualTriggerEngine;
import org.elasticsearch.xpack.watcher.trigger.schedule.ScheduleModule;

public class TriggerModule
extends AbstractModule {
    private final Settings settings;
    private final Set<Class<? extends TriggerEngine>> engines = new HashSet<Class<? extends TriggerEngine>>();

    public TriggerModule(Settings settings) {
        this.settings = settings;
        this.registerStandardEngines();
    }

    public void registerEngine(Class<? extends TriggerEngine> engineType) {
        this.engines.add(engineType);
    }

    protected void registerStandardEngines() {
        this.registerEngine(ScheduleModule.triggerEngineType(this.settings));
        this.registerEngine(ManualTriggerEngine.class);
    }

    protected void configure() {
        Multibinder mbinder = Multibinder.newSetBinder((Binder)this.binder(), TriggerEngine.class);
        for (Class<? extends TriggerEngine> engine : this.engines) {
            this.bind(engine).asEagerSingleton();
            mbinder.addBinding().to(engine);
        }
        this.bind(TriggerService.class).asEagerSingleton();
    }
}

