/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.behavior;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.Activity;
import org.flowable.bpmn.model.Association;
import org.flowable.bpmn.model.BoundaryEvent;
import org.flowable.bpmn.model.CompensateEventDefinition;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.ThrowEvent;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.bpmn.behavior.FlowNodeActivityBehavior;
import org.flowable.engine.impl.bpmn.helper.ScopeUtil;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.eventsubscription.service.EventSubscriptionService;
import org.flowable.eventsubscription.service.impl.persistence.entity.CompensateEventSubscriptionEntity;

public class IntermediateThrowCompensationEventActivityBehavior
extends FlowNodeActivityBehavior {
    private static final long serialVersionUID = 1L;
    protected final CompensateEventDefinition compensateEventDefinition;

    public IntermediateThrowCompensationEventActivityBehavior(CompensateEventDefinition compensateEventDefinition) {
        this.compensateEventDefinition = compensateEventDefinition;
    }

    @Override
    public void execute(DelegateExecution execution) {
        ThrowEvent throwEvent = (ThrowEvent)execution.getCurrentFlowElement();
        String activityRef = this.compensateEventDefinition.getActivityRef();
        CommandContext commandContext = Context.getCommandContext();
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        EventSubscriptionService eventSubscriptionService = processEngineConfiguration.getEventSubscriptionServiceConfiguration().getEventSubscriptionService();
        ArrayList<CompensateEventSubscriptionEntity> eventSubscriptions = new ArrayList<CompensateEventSubscriptionEntity>();
        if (StringUtils.isNotEmpty((CharSequence)activityRef)) {
            List compensationEvents = eventSubscriptionService.findCompensateEventSubscriptionsByProcessInstanceIdAndActivityId(execution.getProcessInstanceId(), activityRef);
            if (compensationEvents == null || compensationEvents.size() == 0) {
                Activity activity;
                String processDefinitionId = execution.getProcessDefinitionId();
                Process process = ProcessDefinitionUtil.getProcess(processDefinitionId);
                if (process == null) {
                    throw new FlowableException("Process model (id = " + processDefinitionId + ") could not be found");
                }
                String compensationActivityId = null;
                FlowElement flowElement = process.getFlowElement(activityRef, true);
                if (flowElement instanceof Activity && (activity = (Activity)flowElement).isForCompensation()) {
                    List associations = process.findAssociationsWithTargetRefRecursive(activity.getId());
                    for (Association association : associations) {
                        BoundaryEvent sourceBoundaryEvent;
                        FlowElement sourceElement = process.getFlowElement(association.getSourceRef(), true);
                        if (!(sourceElement instanceof BoundaryEvent) || (sourceBoundaryEvent = (BoundaryEvent)sourceElement).getAttachedToRefId() == null) continue;
                        compensationActivityId = sourceBoundaryEvent.getAttachedToRefId();
                        break;
                    }
                }
                if (compensationActivityId != null) {
                    compensationEvents = eventSubscriptionService.findCompensateEventSubscriptionsByProcessInstanceIdAndActivityId(execution.getProcessInstanceId(), compensationActivityId);
                }
            }
            eventSubscriptions.addAll(compensationEvents);
        } else {
            Process process = ProcessDefinitionUtil.getProcess(execution.getProcessDefinitionId());
            Object flowElementsContainer = null;
            flowElementsContainer = throwEvent.getSubProcess() == null ? process : throwEvent.getSubProcess();
            for (FlowElement flowElement : flowElementsContainer.getFlowElements()) {
                if (!(flowElement instanceof Activity)) continue;
                eventSubscriptions.addAll(eventSubscriptionService.findCompensateEventSubscriptionsByProcessInstanceIdAndActivityId(execution.getProcessInstanceId(), flowElement.getId()));
            }
        }
        if (!eventSubscriptions.isEmpty()) {
            ScopeUtil.throwCompensationEvent(eventSubscriptions, execution, false);
        }
        this.leave(execution);
    }
}

