/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.rules;

import java.util.Map;
import org.flowable.common.engine.api.repository.EngineDeployment;
import org.flowable.common.engine.api.repository.EngineResource;
import org.flowable.common.engine.impl.EngineDeployer;
import org.flowable.engine.impl.persistence.deploy.DeploymentManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.kie.api.KieBase;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RulesDeployer
implements EngineDeployer {
    private static final Logger LOGGER = LoggerFactory.getLogger(RulesDeployer.class);

    public void deploy(EngineDeployment deployment, Map<String, Object> deploymentSettings) {
        LOGGER.debug("Processing rules deployment {}", (Object)deployment.getName());
        KnowledgeBuilder knowledgeBuilder = null;
        DeploymentManager deploymentManager = CommandContextUtil.getProcessEngineConfiguration().getDeploymentManager();
        Map resources = deployment.getResources();
        for (String resourceName : resources.keySet()) {
            if (!resourceName.endsWith(".drl")) continue;
            LOGGER.info("Processing rules resource {}", (Object)resourceName);
            if (knowledgeBuilder == null) {
                knowledgeBuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
            }
            EngineResource resourceEntity = (EngineResource)resources.get(resourceName);
            byte[] resourceBytes = resourceEntity.getBytes();
            Resource droolsResource = ResourceFactory.newByteArrayResource((byte[])resourceBytes);
            knowledgeBuilder.add(droolsResource, ResourceType.DRL);
        }
        if (knowledgeBuilder != null) {
            KieBase kieBase = knowledgeBuilder.newKieBase();
            deploymentManager.getKnowledgeBaseCache().add(deployment.getId(), (Object)kieBase);
        }
    }
}

