/*
 * Decompiled with CFR 0.152.
 */
package org.kie.integration.tomcat;

import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.catalina.Realm;
import org.apache.catalina.realm.GenericPrincipal;
import org.kie.integration.tomcat.SimpleRolePrincipal;

public class TomcatRealmLoginModule
implements LoginModule {
    private CallbackHandler handler;
    private Subject subject;
    protected boolean committed = false;
    protected Principal principal = null;
    protected Principal rolePrincipal = null;
    private static Realm applicationRealm;

    public static void setRealm(Realm realm) {
        applicationRealm = realm;
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.handler = callbackHandler;
        this.subject = subject;
    }

    @Override
    public boolean login() throws LoginException {
        Callback[] callbacks = new Callback[]{new NameCallback("login"), new PasswordCallback("password", true)};
        try {
            this.handler.handle(callbacks);
            String name = ((NameCallback)callbacks[0]).getName();
            String password = String.valueOf(((PasswordCallback)callbacks[1]).getPassword());
            this.principal = applicationRealm.authenticate(name, password);
            if (this.principal != null) {
                return true;
            }
            throw new LoginException("Authentication failed");
        }
        catch (IOException e) {
            throw new LoginException(e.getMessage());
        }
        catch (UnsupportedCallbackException e) {
            throw new LoginException(e.getMessage());
        }
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.principal == null) {
            return false;
        }
        if (!this.subject.getPrincipals().contains(this.principal)) {
            this.subject.getPrincipals().add(this.principal);
            if (this.principal instanceof GenericPrincipal) {
                String[] roles = ((GenericPrincipal)this.principal).getRoles();
                this.rolePrincipal = new SimpleRolePrincipal(roles);
                this.subject.getPrincipals().add(this.rolePrincipal);
            }
        }
        this.committed = true;
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (this.principal == null) {
            return false;
        }
        if (this.committed) {
            this.logout();
        } else {
            this.committed = false;
            this.principal = null;
            this.rolePrincipal = null;
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject.getPrincipals().remove(this.principal);
        this.subject.getPrincipals().remove(this.rolePrincipal);
        this.committed = false;
        this.principal = null;
        this.rolePrincipal = null;
        return true;
    }
}

