/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.query;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.olap4j.Axis;
import org.olap4j.CellSet;
import org.olap4j.OlapConnection;
import org.olap4j.OlapException;
import org.olap4j.OlapStatement;
import org.olap4j.impl.NamedListImpl;
import org.olap4j.mdx.ParseTreeWriter;
import org.olap4j.mdx.SelectNode;
import org.olap4j.metadata.Catalog;
import org.olap4j.metadata.Cube;
import org.olap4j.metadata.Hierarchy;
import org.olap4j.metadata.Level;
import org.olap4j.metadata.Measure;
import org.olap4j.metadata.Member;
import org.olap4j.metadata.NamedList;
import org.olap4j.metadata.Property;
import org.saiku.query.ISortableQuerySet;
import org.saiku.query.Olap4jNodeConverter;
import org.saiku.query.QueryAxis;
import org.saiku.query.QueryDetails;
import org.saiku.query.QueryHierarchy;
import org.saiku.query.QueryLevel;
import org.saiku.query.metadata.CalculatedMeasure;
import org.saiku.query.metadata.CalculatedMember;
import org.saiku.query.util.QueryUtil;

public class Query {
    protected final String name;
    protected Map<Axis, QueryAxis> axes = new HashMap<Axis, QueryAxis>();
    protected QueryAxis across;
    protected QueryAxis down;
    protected QueryAxis filter;
    protected QueryAxis unused;
    protected final Cube cube;
    protected Map<String, QueryHierarchy> hierarchyMap = new HashMap<String, QueryHierarchy>();
    protected NamedList<CalculatedMeasure> calculatedMeasures = new NamedListImpl();
    protected QueryDetails details;
    protected boolean selectDefaultMembers = true;
    private final OlapConnection connection;
    private ISortableQuerySet.HierarchizeMode defaultHierarchizeMode = ISortableQuerySet.HierarchizeMode.PRE;
    private boolean visualTotals = false;
    private String visualTotalsPattern;
    private boolean lowestLevelsOnly = false;
    private Map<String, String> parameters = new HashMap<String, String>();
    private Map<String, List<String>> aggregators = new HashMap<String, List<String>>();

    public Query(String name, Cube cube) throws SQLException {
        this.name = name;
        this.cube = cube;
        Catalog catalog = cube.getSchema().getCatalog();
        this.connection = (OlapConnection)catalog.getMetaData().getConnection().unwrap(OlapConnection.class);
        this.connection.setCatalog(catalog.getName());
        this.unused = new QueryAxis(this, null);
        for (Hierarchy hierarchy : cube.getHierarchies()) {
            QueryHierarchy queryHierarchy = new QueryHierarchy(this, hierarchy);
            this.unused.getQueryHierarchies().add(queryHierarchy);
            this.hierarchyMap.put(queryHierarchy.getUniqueName(), queryHierarchy);
        }
        this.across = new QueryAxis(this, (Axis)Axis.COLUMNS);
        this.down = new QueryAxis(this, (Axis)Axis.ROWS);
        this.filter = new QueryAxis(this, (Axis)Axis.FILTER);
        this.axes.put(null, this.unused);
        this.axes.put((Axis)Axis.COLUMNS, this.across);
        this.axes.put((Axis)Axis.ROWS, this.down);
        this.axes.put((Axis)Axis.FILTER, this.filter);
        this.details = new QueryDetails(this, (Axis)Axis.COLUMNS);
    }

    public SelectNode getSelect() throws OlapException {
        try {
            return Olap4jNodeConverter.toQuery(this);
        }
        catch (Exception e) {
            throw new OlapException("Error creating Select", (Throwable)e);
        }
    }

    public String getMdx() throws OlapException {
        StringWriter writer = new StringWriter();
        this.getSelect().unparse(new ParseTreeWriter(new PrintWriter(writer)));
        return ((Object)writer).toString();
    }

    public Cube getCube() {
        return this.cube;
    }

    public OlapConnection getConnection() {
        return this.connection;
    }

    public Catalog getCatalog() {
        return this.cube.getSchema().getCatalog();
    }

    public QueryHierarchy getHierarchy(String name) {
        if (this.hierarchyMap.containsKey(name)) {
            return this.hierarchyMap.get(name);
        }
        for (QueryHierarchy qh : this.hierarchyMap.values()) {
            if (!qh.getName().equals(name)) continue;
            return qh;
        }
        return null;
    }

    public QueryHierarchy getHierarchy(Hierarchy hierarchy) {
        if (hierarchy == null) {
            return null;
        }
        return this.hierarchyMap.get(hierarchy.getUniqueName());
    }

    public QueryLevel getLevel(Hierarchy hierarchy, String name) {
        QueryHierarchy h = this.hierarchyMap.get(hierarchy.getUniqueName());
        return h.getActiveLevel(name);
    }

    public QueryLevel getLevel(Level level) {
        return this.getLevel(level.getHierarchy(), level.getName());
    }

    public QueryLevel getLevel(String uniqueLevelName) {
        if (StringUtils.isNotBlank((String)uniqueLevelName)) {
            for (QueryHierarchy qh : this.hierarchyMap.values()) {
                for (QueryLevel ql : qh.getActiveQueryLevels()) {
                    if (!ql.getUniqueName().equals(uniqueLevelName)) continue;
                    return ql;
                }
            }
        }
        return null;
    }

    public void swapAxes() {
        if (this.axes.size() != 4) {
            throw new IllegalArgumentException();
        }
        ArrayList<QueryHierarchy> tmpAcross = new ArrayList<QueryHierarchy>();
        tmpAcross.addAll(this.across.getQueryHierarchies());
        ArrayList<QueryHierarchy> tmpDown = new ArrayList<QueryHierarchy>();
        tmpDown.addAll(this.down.getQueryHierarchies());
        this.across.getQueryHierarchies().clear();
        HashMap acrossChildList = new HashMap();
        for (int cpt = 0; cpt < tmpAcross.size(); ++cpt) {
            acrossChildList.put(cpt, tmpAcross.get(cpt));
        }
        this.down.getQueryHierarchies().clear();
        HashMap downChildList = new HashMap();
        for (int cpt = 0; cpt < tmpDown.size(); ++cpt) {
            downChildList.put(cpt, tmpDown.get(cpt));
        }
        this.across.getQueryHierarchies().addAll(tmpDown);
        this.down.getQueryHierarchies().addAll(tmpAcross);
    }

    public QueryAxis getAxis(Axis axis) {
        return this.axes.get(axis);
    }

    public Map<Axis, QueryAxis> getAxes() {
        return this.axes;
    }

    public CalculatedMember createCalculatedMember(QueryHierarchy hierarchy, String name, String formula, Map<Property, Object> properties) {
        Hierarchy h = hierarchy.getHierarchy();
        CalculatedMember cm = new CalculatedMember(h.getDimension(), h, name, name, null, Member.Type.FORMULA, formula, null);
        this.addCalculatedMember(hierarchy, cm);
        return cm;
    }

    public CalculatedMember createCalculatedMember(QueryHierarchy hierarchy, Member parentMember, String name, String formula, Map<Property, Object> properties) {
        Hierarchy h = hierarchy.getHierarchy();
        CalculatedMember cm = new CalculatedMember(h.getDimension(), h, name, name, parentMember, Member.Type.FORMULA, formula, null);
        this.addCalculatedMember(hierarchy, cm);
        return cm;
    }

    public void addCalculatedMember(QueryHierarchy hierarchy, CalculatedMember cm) {
        hierarchy.addCalculatedMember(cm);
    }

    public NamedList<CalculatedMember> getCalculatedMembers(QueryHierarchy hierarchy) {
        return hierarchy.getCalculatedMembers();
    }

    public NamedList<CalculatedMember> getCalculatedMembers() {
        NamedListImpl cm = new NamedListImpl();
        for (QueryHierarchy h : this.hierarchyMap.values()) {
            cm.addAll(h.getCalculatedMembers());
        }
        return cm;
    }

    public CalculatedMeasure createCalculatedMeasure(String name, String formula, Map<Property, Object> properties) {
        if (this.cube.getMeasures().size() > 0) {
            Measure first = (Measure)this.cube.getMeasures().get(0);
            return this.createCalculatedMeasure(first.getHierarchy(), name, formula, properties);
        }
        throw new RuntimeException("There has to be at least one valid measure in the cube to create a calculated measure!");
    }

    public CalculatedMeasure createCalculatedMeasure(Hierarchy measureHierarchy, String name, String formula, Map<Property, Object> properties) {
        CalculatedMeasure cm = new CalculatedMeasure(measureHierarchy, name, name, formula, null);
        this.addCalculatedMeasure(cm);
        return cm;
    }

    public void addCalculatedMeasure(CalculatedMeasure cm) {
        this.calculatedMeasures.add((Object)cm);
    }

    public NamedList<CalculatedMeasure> getCalculatedMeasures() {
        return this.calculatedMeasures;
    }

    public CalculatedMeasure getCalculatedMeasure(String name) {
        return (CalculatedMeasure)this.calculatedMeasures.get(name);
    }

    public Measure getMeasure(String name) {
        for (Measure m : this.cube.getMeasures()) {
            if (name != null && name.equals(m.getName())) {
                return m;
            }
            if (name == null || !m.getUniqueName().equals(name)) continue;
            return m;
        }
        return null;
    }

    public QueryDetails getDetails() {
        return this.details;
    }

    public QueryAxis getUnusedAxis() {
        return this.unused;
    }

    public CellSet execute() throws OlapException {
        SelectNode mdx = this.getSelect();
        Catalog catalog = this.getCatalog();
        try {
            this.connection.setCatalog(catalog.getName());
        }
        catch (SQLException e) {
            throw new OlapException("Error while executing query", (Throwable)e);
        }
        OlapStatement olapStatement = this.connection.createStatement();
        return olapStatement.executeOlapQuery(mdx);
    }

    public String getName() {
        return this.name;
    }

    public void moveHierarchy(QueryHierarchy hierarchy, Axis axis) {
        this.moveHierarchy(hierarchy, axis, -1);
    }

    public void moveHierarchy(QueryHierarchy hierarchy, Axis axis, int position) {
        QueryAxis oldQueryAxis = this.findAxis(hierarchy);
        QueryAxis newQueryAxis = this.getAxis(axis);
        if (oldQueryAxis != null && newQueryAxis != null && (position > -1 || oldQueryAxis.getLocation() != newQueryAxis.getLocation())) {
            if (oldQueryAxis.getLocation() != null) {
                oldQueryAxis.removeHierarchy(hierarchy);
            }
            if (newQueryAxis.getLocation() != null) {
                if (position > -1) {
                    newQueryAxis.addHierarchy(position, hierarchy);
                } else {
                    newQueryAxis.addHierarchy(hierarchy);
                }
            }
        }
    }

    private QueryAxis findAxis(QueryHierarchy hierarchy) {
        if (this.getUnusedAxis().getQueryHierarchies().contains(hierarchy)) {
            return this.getUnusedAxis();
        }
        Map<Axis, QueryAxis> axes = this.getAxes();
        for (Axis axis : axes.keySet()) {
            if (!axes.get(axis).getQueryHierarchies().contains(hierarchy)) continue;
            return axes.get(axis);
        }
        return null;
    }

    public void setSelectDefaultMembers(boolean selectDefaultMembers) {
        this.selectDefaultMembers = selectDefaultMembers;
    }

    public void setDefaultHierarchizeMode(ISortableQuerySet.HierarchizeMode mode) {
        this.defaultHierarchizeMode = mode;
    }

    public ISortableQuerySet.HierarchizeMode getDefaultHierarchizeMode() {
        return this.defaultHierarchizeMode;
    }

    public void setVisualTotals(boolean visualTotals) {
        if (!visualTotals) {
            this.visualTotalsPattern = null;
        }
        this.visualTotals = visualTotals;
    }

    public boolean isVisualTotals() {
        return this.visualTotals;
    }

    public void setVisualTotalsPattern(String pattern) {
        this.visualTotalsPattern = pattern;
    }

    public String getVisualTotalsPattern() {
        return this.visualTotalsPattern;
    }

    public void setLowestLevelsOnly(boolean lowest) {
        this.lowestLevelsOnly = lowest;
    }

    public boolean isLowestLevelsOnly() {
        return this.lowestLevelsOnly;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void retrieveParameters() {
        for (QueryAxis qa : this.getAxes().values()) {
            for (QueryHierarchy qh : qa.getQueryHierarchies()) {
                for (QueryLevel ql : qh.getActiveQueryLevels()) {
                    String pName = ql.getParameterName();
                    if (StringUtils.isNotBlank((String)pName)) {
                        this.addOrSetParameter(pName);
                    }
                    List<String> params = QueryUtil.retrieveSetParameters(ql);
                    this.addOrSetParameters(params);
                }
                List<String> hparams = QueryUtil.retrieveSortableSetParameters(qh);
                this.addOrSetParameters(hparams);
            }
            List<String> qparams = QueryUtil.retrieveSortableSetParameters(qa);
            this.addOrSetParameters(qparams);
        }
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public void setParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    public String getParameter(String parameter) {
        if (this.parameters.containsKey(parameter)) {
            return this.parameters.get(parameter);
        }
        return null;
    }

    public void addOrSetParameters(List<String> parameters) {
        if (parameters != null) {
            for (String param : parameters) {
                this.addOrSetParameter(param);
            }
        }
    }

    public void addOrSetParameter(String parameter) {
        if (StringUtils.isNotBlank((String)parameter) && !this.parameters.containsKey(parameter)) {
            this.parameters.put(parameter, null);
        }
    }

    public List<String> getAggregators(String key) {
        if (this.aggregators.containsKey(key)) {
            return this.aggregators.get(key);
        }
        return new ArrayList<String>();
    }

    public void setAggregators(String key, List<String> aggs) {
        if (StringUtils.isNotBlank((String)key) && aggs != null) {
            this.aggregators.put(key, aggs);
        }
    }

    public BackendFlavor getFlavor() throws OlapException {
        String dataSourceInfo = this.connection.getOlapDatabase().getDataSourceInfo();
        String proivder = this.connection.getOlapDatabase().getProviderName();
        for (BackendFlavor flavor : BackendFlavor.values()) {
            if (!proivder.contains(flavor.token) && !dataSourceInfo.contains(flavor.token)) continue;
            return flavor;
        }
        throw new AssertionError((Object)("Can't determine the backend vendor. (" + dataSourceInfo + ")"));
    }

    public static enum BackendFlavor {
        MONDRIAN("Mondrian"),
        SSAS("Microsoft"),
        PALO("Palo"),
        SAP("SAP"),
        ESSBASE("Essbase"),
        UNKNOWN("");

        private final String token;

        private BackendFlavor(String token) {
            this.token = token;
        }
    }
}

