/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.file.builder;

import java.util.Comparator;
import org.springframework.batch.item.file.MultiResourceItemReader;
import org.springframework.batch.item.file.ResourceAwareItemReaderItemStream;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class MultiResourceItemReaderBuilder<T> {
    private ResourceAwareItemReaderItemStream<? extends T> delegate;
    private Resource[] resources;
    private boolean strict = false;
    private Comparator<Resource> comparator;
    private boolean saveState = true;
    private String name;

    public MultiResourceItemReaderBuilder<T> saveState(boolean saveState) {
        this.saveState = saveState;
        return this;
    }

    public MultiResourceItemReaderBuilder<T> name(String name) {
        this.name = name;
        return this;
    }

    public MultiResourceItemReaderBuilder<T> resources(Resource ... resources) {
        this.resources = resources;
        return this;
    }

    public MultiResourceItemReaderBuilder<T> delegate(ResourceAwareItemReaderItemStream<? extends T> delegate) {
        this.delegate = delegate;
        return this;
    }

    public MultiResourceItemReaderBuilder<T> setStrict(boolean strict) {
        this.strict = strict;
        return this;
    }

    public MultiResourceItemReaderBuilder<T> comparator(Comparator<Resource> comparator) {
        this.comparator = comparator;
        return this;
    }

    public MultiResourceItemReader<T> build() {
        Assert.notNull((Object)this.resources, (String)"resources array is required.");
        Assert.notNull(this.delegate, (String)"delegate is required.");
        if (this.saveState) {
            Assert.state((boolean)StringUtils.hasText((String)this.name), (String)"A name is required when saveState is set to true.");
        }
        MultiResourceItemReader<? extends T> reader = new MultiResourceItemReader<T>();
        reader.setResources(this.resources);
        reader.setDelegate(this.delegate);
        reader.setSaveState(this.saveState);
        reader.setStrict(this.strict);
        if (this.comparator != null) {
            reader.setComparator(this.comparator);
        }
        if (StringUtils.hasText((String)this.name)) {
            reader.setName(this.name);
        }
        return reader;
    }
}

