/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure;

import javax.validation.Validation;
import org.apache.catalina.mbeans.MBeanFactory;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.annotation.Order;
import org.springframework.http.converter.support.AllEncompassingFormHttpMessageConverter;

@Order(value=-2147483627)
public class BackgroundPreinitializer
implements ApplicationListener<ApplicationEnvironmentPreparedEvent> {
    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        try {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    this.runSafely(new MessageConverterInitializer());
                    this.runSafely(new MBeanFactoryInitializer());
                    this.runSafely(new ValidationInitializer());
                }

                public void runSafely(Runnable runnable) {
                    try {
                        runnable.run();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }, "background-preinit");
            thread.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class ValidationInitializer
    implements Runnable {
        private ValidationInitializer() {
        }

        @Override
        public void run() {
            Validation.byDefaultProvider().configure();
        }
    }

    private static class MBeanFactoryInitializer
    implements Runnable {
        private MBeanFactoryInitializer() {
        }

        @Override
        public void run() {
            new MBeanFactory();
        }
    }

    private static class MessageConverterInitializer
    implements Runnable {
        private MessageConverterInitializer() {
        }

        @Override
        public void run() {
            new AllEncompassingFormHttpMessageConverter();
        }
    }
}

