/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.liquibase;

import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import liquibase.integration.spring.SpringLiquibase;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.jpa.EntityManagerFactoryDependsOnPostProcessor;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceBuilder;
import org.springframework.boot.autoconfigure.liquibase.LiquibaseDataSource;
import org.springframework.boot.autoconfigure.liquibase.LiquibaseProperties;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.orm.jpa.AbstractEntityManagerFactoryBean;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.util.Assert;

@Configuration
@ConditionalOnClass(value={SpringLiquibase.class})
@ConditionalOnBean(value={DataSource.class})
@ConditionalOnProperty(prefix="liquibase", name={"enabled"}, matchIfMissing=true)
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class, HibernateJpaAutoConfiguration.class})
public class LiquibaseAutoConfiguration {

    @Configuration
    @ConditionalOnClass(value={LocalContainerEntityManagerFactoryBean.class})
    @ConditionalOnBean(value={AbstractEntityManagerFactoryBean.class})
    protected static class LiquibaseJpaDependencyConfiguration
    extends EntityManagerFactoryDependsOnPostProcessor {
        public LiquibaseJpaDependencyConfiguration() {
            super("liquibase");
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={SpringLiquibase.class})
    @EnableConfigurationProperties(value={LiquibaseProperties.class})
    @Import(value={LiquibaseJpaDependencyConfiguration.class})
    public static class LiquibaseConfiguration {
        private final LiquibaseProperties properties;
        private final ResourceLoader resourceLoader;
        private final DataSource dataSource;
        private final DataSource liquibaseDataSource;

        public LiquibaseConfiguration(LiquibaseProperties properties, ResourceLoader resourceLoader, DataSource dataSource, @LiquibaseDataSource ObjectProvider<DataSource> liquibaseDataSource) {
            this.properties = properties;
            this.resourceLoader = resourceLoader;
            this.dataSource = dataSource;
            this.liquibaseDataSource = (DataSource)liquibaseDataSource.getIfAvailable();
        }

        @PostConstruct
        public void checkChangelogExists() {
            if (this.properties.isCheckChangeLogLocation()) {
                Resource resource = this.resourceLoader.getResource(this.properties.getChangeLog());
                Assert.state((boolean)resource.exists(), (String)("Cannot find changelog location: " + resource + " (please add changelog or check your Liquibase configuration)"));
            }
        }

        @Bean
        public SpringLiquibase liquibase() {
            SpringLiquibase liquibase = new SpringLiquibase();
            liquibase.setChangeLog(this.properties.getChangeLog());
            liquibase.setContexts(this.properties.getContexts());
            liquibase.setDataSource(this.getDataSource());
            liquibase.setDefaultSchema(this.properties.getDefaultSchema());
            liquibase.setDropFirst(this.properties.isDropFirst());
            liquibase.setShouldRun(this.properties.isEnabled());
            liquibase.setLabels(this.properties.getLabels());
            liquibase.setChangeLogParameters(this.properties.getParameters());
            liquibase.setRollbackFile(this.properties.getRollbackFile());
            return liquibase;
        }

        private DataSource getDataSource() {
            if (this.liquibaseDataSource != null) {
                return this.liquibaseDataSource;
            }
            if (this.properties.getUrl() == null) {
                return this.dataSource;
            }
            return DataSourceBuilder.create().url(this.properties.getUrl()).username(this.properties.getUser()).password(this.properties.getPassword()).build();
        }
    }
}

