/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.validation;

import org.springframework.util.Assert;
import org.springframework.validation.Errors;
import org.springframework.validation.SmartValidator;
import org.springframework.validation.Validator;
import org.springframework.validation.beanvalidation.SpringValidatorAdapter;

public class DelegatingValidator
implements SmartValidator {
    private final Validator delegate;

    public DelegatingValidator(javax.validation.Validator targetValidator) {
        this.delegate = new SpringValidatorAdapter(targetValidator);
    }

    public DelegatingValidator(Validator targetValidator) {
        Assert.notNull((Object)targetValidator, (String)"Target Validator must not be null");
        this.delegate = targetValidator;
    }

    public boolean supports(Class<?> clazz) {
        return this.delegate.supports(clazz);
    }

    public void validate(Object target, Errors errors) {
        this.delegate.validate(target, errors);
    }

    public void validate(Object target, Errors errors, Object ... validationHints) {
        if (this.delegate instanceof SmartValidator) {
            ((SmartValidator)this.delegate).validate(target, errors, validationHints);
        } else {
            this.delegate.validate(target, errors);
        }
    }

    protected final Validator getDelegate() {
        return this.delegate;
    }
}

