/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.serviceregistry;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PreDestroy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.web.context.ConfigurableWebServerApplicationContext;
import org.springframework.boot.web.context.WebServerApplicationContext;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.cloud.client.discovery.ManagementServerPortUtils;
import org.springframework.cloud.client.discovery.event.InstanceRegisteredEvent;
import org.springframework.cloud.client.serviceregistry.AutoServiceRegistration;
import org.springframework.cloud.client.serviceregistry.AutoServiceRegistrationProperties;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.cloud.client.serviceregistry.ServiceRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.event.EventListener;
import org.springframework.core.env.Environment;

public abstract class AbstractAutoServiceRegistration<R extends Registration>
implements AutoServiceRegistration,
ApplicationContextAware {
    private static final Log logger = LogFactory.getLog(AbstractAutoServiceRegistration.class);
    private boolean autoStartup = true;
    private AtomicBoolean running = new AtomicBoolean(false);
    private int order = 0;
    private ApplicationContext context;
    private Environment environment;
    private AtomicInteger port = new AtomicInteger(0);
    private final ServiceRegistry<R> serviceRegistry;
    private AutoServiceRegistrationProperties properties;

    @Deprecated
    protected AbstractAutoServiceRegistration(ServiceRegistry<R> serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    protected AbstractAutoServiceRegistration(ServiceRegistry<R> serviceRegistry, AutoServiceRegistrationProperties properties) {
        this.serviceRegistry = serviceRegistry;
        this.properties = properties;
    }

    protected ApplicationContext getContext() {
        return this.context;
    }

    @EventListener(value={WebServerInitializedEvent.class})
    public void bind(WebServerInitializedEvent event) {
        WebServerApplicationContext context = event.getApplicationContext();
        if (context instanceof ConfigurableWebServerApplicationContext && "management".equals(((ConfigurableWebServerApplicationContext)context).getServerNamespace())) {
            return;
        }
        this.port.compareAndSet(0, event.getWebServer().getPort());
        this.start();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
        this.environment = this.context.getEnvironment();
    }

    @Deprecated
    protected Environment getEnvironment() {
        return this.environment;
    }

    @Deprecated
    protected AtomicInteger getPort() {
        return this.port;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void start() {
        if (!this.isEnabled()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Discovery Lifecycle disabled. Not starting");
            }
            return;
        }
        if (!this.running.get()) {
            this.register();
            if (this.shouldRegisterManagement()) {
                this.registerManagement();
            }
            this.context.publishEvent(new InstanceRegisteredEvent<Object>(this, this.getConfiguration()));
            this.running.compareAndSet(false, true);
        }
    }

    protected boolean shouldRegisterManagement() {
        if (this.properties == null || this.properties.isRegisterManagement()) {
            return this.getManagementPort() != null && ManagementServerPortUtils.isDifferent((BeanFactory)this.context);
        }
        return false;
    }

    @Deprecated
    protected abstract Object getConfiguration();

    protected abstract boolean isEnabled();

    @Deprecated
    protected String getManagementServiceId() {
        return this.context.getId() + ":management";
    }

    @Deprecated
    protected String getManagementServiceName() {
        return this.getAppName() + ":management";
    }

    @Deprecated
    protected Integer getManagementPort() {
        return ManagementServerPortUtils.getPort((BeanFactory)this.context);
    }

    @Deprecated
    protected String getAppName() {
        return this.environment.getProperty("spring.application.name", "application");
    }

    @PreDestroy
    public void destroy() {
        this.stop();
    }

    public boolean isRunning() {
        return this.running.get();
    }

    protected AtomicBoolean getRunning() {
        return this.running;
    }

    public int getOrder() {
        return this.order;
    }

    public int getPhase() {
        return 0;
    }

    protected ServiceRegistry<R> getServiceRegistry() {
        return this.serviceRegistry;
    }

    protected abstract R getRegistration();

    protected abstract R getManagementRegistration();

    protected void register() {
        this.serviceRegistry.register(this.getRegistration());
    }

    protected void registerManagement() {
        R registration = this.getManagementRegistration();
        if (registration != null) {
            this.serviceRegistry.register(registration);
        }
    }

    protected void deregister() {
        this.serviceRegistry.deregister(this.getRegistration());
    }

    protected void deregisterManagement() {
        R registration = this.getManagementRegistration();
        if (registration != null) {
            this.serviceRegistry.deregister(registration);
        }
    }

    public void stop() {
        if (this.getRunning().compareAndSet(true, false) && this.isEnabled()) {
            this.deregister();
            if (this.shouldRegisterManagement()) {
                this.deregisterManagement();
            }
            this.serviceRegistry.close();
        }
    }
}

