/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.ratelimit;

import java.util.Map;
import org.springframework.cloud.gateway.event.FilterArgsEvent;
import org.springframework.cloud.gateway.filter.ratelimit.RateLimiter;
import org.springframework.cloud.gateway.support.AbstractStatefulConfigurable;
import org.springframework.cloud.gateway.support.ConfigurationService;
import org.springframework.context.ApplicationListener;
import org.springframework.core.style.ToStringCreator;

public abstract class AbstractRateLimiter<C>
extends AbstractStatefulConfigurable<C>
implements RateLimiter<C>,
ApplicationListener<FilterArgsEvent> {
    private String configurationPropertyName;
    private ConfigurationService configurationService;

    protected AbstractRateLimiter(Class<C> configClass, String configurationPropertyName, ConfigurationService configurationService) {
        super(configClass);
        this.configurationPropertyName = configurationPropertyName;
        this.configurationService = configurationService;
    }

    protected String getConfigurationPropertyName() {
        return this.configurationPropertyName;
    }

    protected void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public void onApplicationEvent(FilterArgsEvent event) {
        Map<String, Object> args = event.getArgs();
        if (args.isEmpty() || !this.hasRelevantKey(args)) {
            return;
        }
        String routeId = event.getRouteId();
        Object routeConfig = this.newConfig();
        if (this.configurationService != null) {
            ((ConfigurationService.InstanceBuilder)((ConfigurationService.InstanceBuilder)this.configurationService.with(routeConfig).name(this.configurationPropertyName)).normalizedProperties(args)).bind();
        }
        this.getConfig().put(routeId, routeConfig);
    }

    private boolean hasRelevantKey(Map<String, Object> args) {
        return args.keySet().stream().anyMatch(key -> key.startsWith(this.configurationPropertyName + "."));
    }

    @Override
    public String toString() {
        return new ToStringCreator((Object)this).append("configurationPropertyName", (Object)this.configurationPropertyName).append("config", this.getConfig()).append("configClass", this.getConfigClass()).toString();
    }
}

