/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.route;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.cloud.gateway.event.RefreshRoutesEvent;
import org.springframework.cloud.gateway.event.RefreshRoutesResultEvent;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import reactor.cache.CacheFlux;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Signal;

public class CachingRouteLocator
implements Ordered,
RouteLocator,
ApplicationListener<RefreshRoutesEvent>,
ApplicationEventPublisherAware {
    private static final Log log = LogFactory.getLog(CachingRouteLocator.class);
    private static final String CACHE_KEY = "routes";
    private final RouteLocator delegate;
    private final Flux<Route> routes;
    private final Map<String, List> cache = new ConcurrentHashMap<String, List>();
    private ApplicationEventPublisher applicationEventPublisher;

    public CachingRouteLocator(RouteLocator delegate) {
        this.delegate = delegate;
        this.routes = CacheFlux.lookup(this.cache, (Object)CACHE_KEY, Route.class).onCacheMissResume(this::fetch);
    }

    private Flux<Route> fetch() {
        return this.delegate.getRoutes().sort((Comparator)AnnotationAwareOrderComparator.INSTANCE);
    }

    private Flux<Route> fetch(Map<String, Object> metadata) {
        return this.delegate.getRoutesByMetadata(metadata).sort((Comparator)AnnotationAwareOrderComparator.INSTANCE);
    }

    @Override
    public Flux<Route> getRoutes() {
        return this.routes;
    }

    public Flux<Route> refresh() {
        this.cache.remove(CACHE_KEY);
        return this.routes;
    }

    public void onApplicationEvent(RefreshRoutesEvent event) {
        try {
            if (this.cache.containsKey(CACHE_KEY) && event.isScoped()) {
                Mono scopedRoutes = this.fetch(event.getMetadata()).collect(Collectors.toList()).onErrorResume(s -> Mono.just(List.of()));
                scopedRoutes.subscribe(scopedRoutesList -> Flux.concat((Publisher[])new Publisher[]{Flux.fromIterable((Iterable)scopedRoutesList), this.getNonScopedRoutes(event)}).sort((Comparator)AnnotationAwareOrderComparator.INSTANCE).materialize().collect(Collectors.toList()).subscribe(this::publishRefreshEvent, this::handleRefreshError), this::handleRefreshError);
            } else {
                Mono allRoutes = this.fetch().collect(Collectors.toList());
                allRoutes.subscribe(list -> Flux.fromIterable((Iterable)list).materialize().collect(Collectors.toList()).subscribe(this::publishRefreshEvent, this::handleRefreshError), this::handleRefreshError);
            }
        }
        catch (Throwable e) {
            this.handleRefreshError(e);
        }
    }

    private void publishRefreshEvent(List<Signal<Route>> signals) {
        this.cache.put(CACHE_KEY, signals);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new RefreshRoutesResultEvent(this));
    }

    private Flux<Route> getNonScopedRoutes(RefreshRoutesEvent scopedEvent) {
        return this.getRoutes().filter(route -> !RouteLocator.matchMetadata(route.getMetadata(), scopedEvent.getMetadata()));
    }

    private void handleRefreshError(Throwable throwable) {
        if (log.isErrorEnabled()) {
            log.error((Object)"Refresh routes error !!!", throwable);
        }
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new RefreshRoutesResultEvent(this, throwable));
    }

    public int getOrder() {
        return 0;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }
}

