/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.converter;

import org.springframework.cloud.stream.converter.ConversionException;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.MimeType;
import org.springframework.util.StringUtils;

public abstract class MessageConverterUtils {
    public static final MimeType X_SPRING_TUPLE = MimeType.valueOf((String)"application/x-spring-tuple");
    public static final MimeType X_JAVA_OBJECT = MimeType.valueOf((String)"application/x-java-object");
    public static final MimeType X_JAVA_SERIALIZED_OBJECT = MimeType.valueOf((String)"application/x-java-serialized-object");

    public static Class<?> getJavaTypeForJavaObjectContentType(MimeType contentType) {
        Assert.isTrue((boolean)X_JAVA_OBJECT.includes(contentType), (String)("Content type must be " + X_JAVA_OBJECT.toString() + ", or included in it"));
        if (contentType.getParameter("type") != null) {
            try {
                return ClassUtils.forName((String)contentType.getParameter("type"), null);
            }
            catch (Exception e) {
                throw new ConversionException(e.getMessage(), e);
            }
        }
        return Object.class;
    }

    public static MimeType javaObjectMimeType(Class<?> clazz) {
        return MimeType.valueOf((String)("application/x-java-object;type=" + clazz.getName()));
    }

    public static MimeType getMimeType(String contentTypeString) {
        MimeType mimeType = null;
        if (StringUtils.hasText((String)contentTypeString)) {
            try {
                mimeType = MessageConverterUtils.resolveContentType(contentTypeString);
            }
            catch (ClassNotFoundException cfe) {
                throw new IllegalArgumentException("Could not find the class required for " + contentTypeString, cfe);
            }
        }
        return mimeType;
    }

    public static MimeType resolveContentType(String type) throws ClassNotFoundException, LinkageError {
        if (!type.contains("/")) {
            Class<?> javaType = MessageConverterUtils.resolveJavaType(type);
            return MessageConverterUtils.javaObjectMimeType(javaType);
        }
        return MimeType.valueOf((String)type);
    }

    public static Class<?> resolveJavaType(String type) throws ClassNotFoundException, LinkageError {
        return ClassUtils.forName((String)type, null);
    }
}

