/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.token.grant.implicit;

import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.springframework.http.HttpHeaders;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.oauth2.client.resource.OAuth2AccessDeniedException;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.resource.UserRedirectRequiredException;
import org.springframework.security.oauth2.client.token.AccessTokenProvider;
import org.springframework.security.oauth2.client.token.AccessTokenRequest;
import org.springframework.security.oauth2.client.token.OAuth2AccessTokenSupport;
import org.springframework.security.oauth2.client.token.grant.implicit.ImplicitResourceDetails;
import org.springframework.security.oauth2.common.DefaultOAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2RefreshToken;
import org.springframework.security.oauth2.common.util.OAuth2Utils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResponseExtractor;

public class ImplicitAccessTokenProvider
extends OAuth2AccessTokenSupport
implements AccessTokenProvider {
    @Override
    public boolean supportsResource(OAuth2ProtectedResourceDetails resource) {
        return resource instanceof ImplicitResourceDetails && "implicit".equals(resource.getGrantType());
    }

    @Override
    public boolean supportsRefresh(OAuth2ProtectedResourceDetails resource) {
        return false;
    }

    @Override
    public OAuth2AccessToken refreshAccessToken(OAuth2ProtectedResourceDetails resource, OAuth2RefreshToken refreshToken, AccessTokenRequest request) throws UserRedirectRequiredException {
        return null;
    }

    @Override
    public OAuth2AccessToken obtainAccessToken(OAuth2ProtectedResourceDetails details, AccessTokenRequest request) throws UserRedirectRequiredException, AccessDeniedException, OAuth2AccessDeniedException {
        ImplicitResourceDetails resource = (ImplicitResourceDetails)details;
        try {
            OAuth2AccessToken token = this.retrieveToken(request, resource, this.getParametersForTokenRequest(resource, request), this.getHeadersForTokenRequest(request));
            if (token == null) {
                throw new UserRedirectRequiredException(resource.getUserAuthorizationUri(), request.toSingleValueMap());
            }
            return token;
        }
        catch (UserRedirectRequiredException e) {
            throw new UserRedirectRequiredException(e.getRedirectUri(), request.toSingleValueMap());
        }
    }

    @Override
    protected ResponseExtractor<OAuth2AccessToken> getResponseExtractor() {
        return new ImplicitResponseExtractor();
    }

    private HttpHeaders getHeadersForTokenRequest(AccessTokenRequest request) {
        HttpHeaders headers = new HttpHeaders();
        headers.putAll(request.getHeaders());
        if (request.getCookie() != null) {
            headers.set("Cookie", request.getCookie());
        }
        return headers;
    }

    private MultiValueMap<String, String> getParametersForTokenRequest(ImplicitResourceDetails resource, AccessTokenRequest request) {
        LinkedMultiValueMap form = new LinkedMultiValueMap();
        form.set((Object)"response_type", (Object)"token");
        form.set((Object)"client_id", (Object)resource.getClientId());
        if (resource.isScoped()) {
            StringBuilder builder = new StringBuilder();
            List<String> scope = resource.getScope();
            if (scope != null) {
                Iterator<String> scopeIt = scope.iterator();
                while (scopeIt.hasNext()) {
                    builder.append(scopeIt.next());
                    if (!scopeIt.hasNext()) continue;
                    builder.append(' ');
                }
            }
            form.set((Object)"scope", (Object)builder.toString());
        }
        for (String key : request.keySet()) {
            form.put((Object)key, request.get(key));
        }
        String redirectUri = resource.getRedirectUri(request);
        if (redirectUri == null) {
            throw new IllegalStateException("No redirect URI available in request");
        }
        form.set((Object)"redirect_uri", (Object)redirectUri);
        return form;
    }

    private final class ImplicitResponseExtractor
    implements ResponseExtractor<OAuth2AccessToken> {
        private ImplicitResponseExtractor() {
        }

        public OAuth2AccessToken extractData(ClientHttpResponse response) throws IOException {
            URI location = response.getHeaders().getLocation();
            if (location == null) {
                return null;
            }
            String fragment = location.getFragment();
            OAuth2AccessToken accessToken = DefaultOAuth2AccessToken.valueOf(OAuth2Utils.extractMap(fragment));
            if (accessToken.getValue() == null) {
                throw new UserRedirectRequiredException(location.toString(), Collections.<String, String>emptyMap());
            }
            return accessToken;
        }
    }
}

