/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.auth.service.impl;

import com.alibaba.fastjson.JSON;
import com.cyberway.msf.commons.auth.service.AuthenticationService;
import com.cyberway.msf.commons.auth.support.CommonsAuthProperties;
import com.cyberway.msf.commons.auth.util.JwtUtils;
import com.cyberway.msf.commons.cache.RedisUtils;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Service;

@Service
public class AuthenticationServiceImpl
implements AuthenticationService {
    private static final Logger logger = LoggerFactory.getLogger(AuthenticationServiceImpl.class);
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private JwtUtils jwtUtils;
    @Autowired
    private CommonsAuthProperties commonsAuthProperties;

    @Override
    public boolean authenticate(ServerHttpRequest request) {
        String token = this.getTokenFromHeader(request);
        if (StringUtils.isNotEmpty((CharSequence)token) && this.isTokenValid(token) && this.isTokenInRedis(token)) {
            return this.refreshToken(token, this.commonsAuthProperties.getTokenTime());
        }
        return false;
    }

    @Override
    public Set<String> getApiList(ServerHttpRequest request) {
        Object apiListJson;
        HashSet<String> apiList = new HashSet<String>();
        String token = this.getTokenFromHeader(request);
        if (StringUtils.isNotBlank((CharSequence)token) && (apiListJson = this.redisUtils.getHashOrigin(String.format("loginInfo:%s", token), (Object)"apiList")) != null) {
            apiList.addAll(JSON.parseArray((String)apiListJson.toString(), String.class));
        }
        return apiList;
    }

    @Override
    public boolean isTokenValid(ServerHttpRequest request) {
        String token = this.getTokenFromHeader(request);
        return this.isTokenValid(token);
    }

    @Override
    public boolean isTokenInRedis(ServerHttpRequest request) {
        String token = this.getTokenFromHeader(request);
        return this.isTokenInRedis(token);
    }

    @Override
    public boolean isUserLogged(ServerHttpRequest request) {
        String token = this.getTokenFromHeader(request);
        if (this.isTokenValid(token)) {
            JwtUtils.JwtResult jwtResult = this.checkToken(token);
            String userId = jwtResult.getUid();
            String lastToken = (String)this.redisUtils.getOrigin(String.format("auth_user_token_%s", userId));
            return lastToken != null && !lastToken.equals(token);
        }
        return false;
    }

    private boolean isTokenValid(String token) {
        boolean isValid = true;
        if (StringUtils.isBlank((CharSequence)token)) {
            isValid = false;
        } else {
            JwtUtils.JwtResult jwtResult = this.checkToken(token);
            if (!jwtResult.isSuccess()) {
                isValid = false;
            }
        }
        return isValid;
    }

    private JwtUtils.JwtResult checkToken(String token) {
        logger.debug("Start to check token");
        JwtUtils.JwtResult jwtResult = this.jwtUtils.checkToken(token);
        logger.debug("End to check token with result : {}", (Object)jwtResult);
        return jwtResult;
    }

    private boolean isTokenInRedis(String token) {
        if (StringUtils.isBlank((CharSequence)token)) {
            return false;
        }
        return Boolean.TRUE.equals(this.redisUtils.hasKeyOrigin(String.format("loginInfo:%s", token)));
    }

    private Boolean refreshToken(String token, Long expireTime) {
        String key = String.format("loginInfo:%s", token);
        return this.redisUtils.expireOrigin(key, expireTime.longValue());
    }

    private String getTokenFromHeader(ServerHttpRequest request) {
        String token = "" + StringUtils.join((Iterable)request.getHeaders().get((Object)"Authorization"), (char)',');
        logger.debug("The token is : {}", (Object)token);
        return token;
    }
}

