/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.poi.exporter;

import com.cyberway.msf.commons.poi.exporter.EasyExcelExport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.core.io.Resource;

public final class EasyExcelExportBuilder {
    private int headerRowNum = 1;
    private String sheetName;
    private String[] headerRowNames;
    private List<Object[]> dataArray;
    private List<List<Object>> dataList = new ArrayList<List<Object>>();
    private int defaultColumnWidth = 18;
    private String exportName;
    private Resource template;

    private EasyExcelExportBuilder() {
    }

    public static EasyExcelExportBuilder anEasyExcelExport() {
        return new EasyExcelExportBuilder();
    }

    public EasyExcelExportBuilder withHeaderRowNum(int headerRowNum) {
        this.headerRowNum = headerRowNum;
        return this;
    }

    public EasyExcelExportBuilder withSheetName(String sheetName) {
        this.sheetName = sheetName;
        return this;
    }

    public EasyExcelExportBuilder withHeaderRowNames(String[] headerRowNames) {
        this.headerRowNames = headerRowNames;
        return this;
    }

    public EasyExcelExportBuilder withDataArray(List<Object[]> dataArray) {
        this.dataArray = dataArray;
        return this;
    }

    public EasyExcelExportBuilder withDataList(List<List<Object>> dataList) {
        this.dataList = dataList;
        return this;
    }

    public EasyExcelExportBuilder withDefaultColumnWidth(int defaultColumnWidth) {
        this.defaultColumnWidth = defaultColumnWidth;
        return this;
    }

    public EasyExcelExportBuilder withExportName(String exportName) {
        this.exportName = exportName;
        return this;
    }

    public EasyExcelExportBuilder withTemplate(Resource template) {
        this.template = template;
        this.exportName = template.getFilename();
        return this;
    }

    public EasyExcelExport build() {
        EasyExcelExport easyExcelExport = new EasyExcelExport();
        easyExcelExport.setTemplate(this.template);
        easyExcelExport.setHeaderRowNum(this.headerRowNum);
        easyExcelExport.setSheetName(this.sheetName);
        easyExcelExport.setHeaderRowNames(this.headerRowNames);
        easyExcelExport.setData(this.dataList);
        if (null != this.dataArray && null != this.dataList) {
            for (Object[] datum : this.dataArray) {
                this.dataList.add(Arrays.asList(datum));
            }
        }
        easyExcelExport.setDefaultColumnWidth(this.defaultColumnWidth);
        easyExcelExport.setExportName(this.exportName);
        return easyExcelExport;
    }
}

