/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.transaction.seata.rest;

import com.cyberway.msf.commons.transaction.seata.rest.SeataRestTemplateInterceptor;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestTemplate;

@Configuration
@ConditionalOnProperty(prefix="spring.cloud.alibaba.seata", value={"tx-service-group"})
public class SeataRestTemplateAutoConfiguration {
    @Autowired(required=false)
    private Collection<RestTemplate> restTemplates;
    @Autowired
    private SeataRestTemplateInterceptor seataRestTemplateInterceptor;

    @Bean
    public SeataRestTemplateInterceptor seataRestTemplateInterceptor() {
        return new SeataRestTemplateInterceptor();
    }

    @PostConstruct
    public void init() {
        if (this.restTemplates != null) {
            for (RestTemplate restTemplate : this.restTemplates) {
                ArrayList<SeataRestTemplateInterceptor> interceptors = new ArrayList<SeataRestTemplateInterceptor>(restTemplate.getInterceptors());
                interceptors.add(this.seataRestTemplateInterceptor);
                restTemplate.setInterceptors(interceptors);
            }
        }
    }
}

