/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.common.config.impl;

import com.tcbj.common.config.Config;
import com.tcbj.common.config.ConfigLoader;
import com.tcbj.common.config.GenericConfigObject;
import com.tcbj.common.config.exception.MultipleKeysException;
import com.tcbj.common.config.exception.ParamErrorException;
import com.tcbj.common.config.impl.MapConfigImpl;
import com.tcbj.util.Beans;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalConfigLoader
implements ConfigLoader {
    @Override
    public Config loadConfig(GenericConfigObject configObject) {
        HashMap<String, String> config = new HashMap<String, String>();
        if (Beans.isEmpty((Object)configObject.getLocalFiles())) {
            throw new ParamErrorException("localFiles param is needed");
        }
        for (String s : configObject.getLocalFiles()) {
            this.loadFile(null, s, config);
        }
        MapConfigImpl c = new MapConfigImpl(config);
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFile(String env, String file, Map<String, String> config) {
        Properties p = new Properties();
        InputStream is = null;
        try {
            is = new FileInputStream(this.getClass().getResource(file).getFile());
            p.load(is);
            String globalEnv = Beans.isEmpty((Object)env) ? p.getProperty("env") : env;
            for (Object s : p.keySet()) {
                if (config.containsKey(s.toString())) {
                    throw new MultipleKeysException("find multiple key:" + s.toString());
                }
                if (Beans.isNotEmpty((Object)globalEnv)) {
                    if (s.toString().startsWith(globalEnv)) {
                        config.put(s.toString().replace(globalEnv + "_", ""), p.get(s).toString());
                        continue;
                    }
                    if (!s.toString().startsWith("include")) continue;
                    this.loadFile(globalEnv, p.get(s).toString(), config);
                    continue;
                }
                config.put(s.toString(), p.get(s).toString());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (Beans.isNotEmpty(is)) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

