/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.config.controller;

import com.tcbj.util.Beans;
import com.tcbj.util.Jsons;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.ui.Model;

public abstract class BaseController {
    public static final String DEL = "del";
    public static final String ADD = "add";
    public static final String EDIT = "edit";

    public void globalEdit(HttpServletRequest request, HttpServletResponse response, Model model) {
        String oper = request.getParameter("oper");
        boolean p = false;
        if (DEL.equals(oper)) {
            p = this.delete(request, response);
        } else if (ADD.equals(oper)) {
            p = this.add(request, response);
        } else if (EDIT.equals(oper)) {
            p = this.edit(request, response);
        }
        this.writeJson(response, p);
    }

    public abstract boolean add(HttpServletRequest var1, HttpServletResponse var2);

    public abstract boolean edit(HttpServletRequest var1, HttpServletResponse var2);

    public abstract boolean delete(HttpServletRequest var1, HttpServletResponse var2);

    protected void writeJson(HttpServletResponse response, Object obj) {
        try {
            response.getWriter().write(Jsons.toJson((Object)obj));
            response.flushBuffer();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected Map<String, String> getFilterMap(HttpServletRequest request) {
        HashMap<String, String> map = new HashMap<String, String>();
        String filters = request.getParameter("filters");
        try {
            Map f;
            Object rules;
            if (Beans.isNotEmpty((Object)filters) && List.class.isAssignableFrom((rules = (f = (Map)Jsons.toBean((String)filters, Map.class)).get("rules")).getClass())) {
                List rm = (List)rules;
                for (Map p : rm) {
                    map.put(p.get("field").toString(), p.get("data").toString());
                }
            }
        }
        catch (Exception e) {
            System.out.println("get filter param error");
        }
        return map;
    }
}

