/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.config.controller;

import com.tcbj.config.controller.BaseController;
import com.tcbj.config.service.ConfigService;
import com.tcbj.config.util.Page;
import com.tcbj.util.Beans;
import com.tcbj.util.Jsons;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/global"})
public class InnerController
extends BaseController {
    @Autowired
    private ConfigService configService;

    @RequestMapping(value={"/main.shtml"})
    public String findSchemaTree(Model model) {
        List<Map<String, Object>> tree = this.configService.queryAllSchema();
        model.addAttribute("schemaTree", tree);
        return "index";
    }

    @RequestMapping(value={"/addTreeNode.shtml"})
    @ResponseBody
    public boolean addSchema(HttpServletRequest request, HttpServletResponse response, Model model) {
        String copy = request.getParameter("copy");
        boolean isCopy = Beans.isEmpty((Object)copy) ? false : "1".equals(copy);
        String schemaCode = request.getParameter("schemaCode");
        String schemaName = request.getParameter("schemaName");
        boolean flag = false;
        if (isCopy) {
            String copyCode = request.getParameter("copyCode");
            flag = this.configService.copySchema(copyCode, schemaCode, schemaName);
        } else {
            flag = this.configService.saveSchema(schemaCode, schemaName);
        }
        return flag;
    }

    @RequestMapping(value={"/propertyList.shtml"})
    @ResponseBody
    public void propertyList(HttpServletRequest request, HttpServletResponse response, Model model) {
        int pageNo = Beans.isEmpty((Object)request.getParameter("pageNo")) ? 1 : Integer.valueOf(request.getParameter("pageNo").toString());
        int pageSize = Beans.isEmpty((Object)request.getParameter("pageSize")) ? 10 : Integer.valueOf(request.getParameter("pageSize").toString());
        String schemaCode = request.getParameter("schemaCode");
        String key = this.getFilterMap(request).get("pKey");
        Page p = this.configService.findPropertyByPage(schemaCode, key, pageNo, pageSize);
        try {
            response.getWriter().write(Jsons.toJson((Object)p));
            response.flushBuffer();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    @RequestMapping(value={"/editProperty.shtml"})
    @ResponseBody
    public void globalEdit(HttpServletRequest request, HttpServletResponse response, Model model) {
        super.globalEdit(request, response, model);
    }

    @Override
    public boolean add(HttpServletRequest request, HttpServletResponse response) {
        String schemaCode = request.getParameter("schemaCode");
        String pKey = request.getParameter("pKey");
        String pValue = request.getParameter("pValue");
        return this.configService.saveOrUpdateProperty(schemaCode, pKey, pValue);
    }

    @Override
    public boolean edit(HttpServletRequest request, HttpServletResponse response) {
        return this.add(request, response);
    }

    @Override
    public boolean delete(HttpServletRequest request, HttpServletResponse response) {
        String schemaCode = request.getParameter("schemaCode");
        String pKey = request.getParameter("pKey");
        return this.configService.deleteProperty(schemaCode, pKey);
    }
}

