/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.config.service;

import com.tcbj.config.service.BaseService;
import com.tcbj.config.util.Page;
import com.tcbj.util.Beans;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service(value="configService")
public class ConfigService
extends BaseService {
    public List<Map<String, Object>> queryAllSchema() {
        String sql = "select schema_code as schemaCode,schema_name as schemaName from global_schema";
        List result = this.jdbcTemplate.queryForList(sql);
        return result;
    }

    public boolean deleteSchema(String schemaCode) {
        String sql = "delete from global_schema a where a.schema_code ='" + schemaCode + "'";
        int r = this.jdbcTemplate.update(sql);
        return r > 0;
    }

    public boolean saveSchema(String schemaCode, String name) {
        String sql = "insert into global_schema(schema_code,schema_name) values(?,?) ON DUPLICATE KEY UPDATE schema_name =?";
        Object[] args = new Object[]{schemaCode, name, name};
        int r = this.jdbcTemplate.update(sql, args);
        return r > 0;
    }

    public Map<String, String> queryPropertyBySchemaIntoMap(String schemaCode) {
        List<Map<String, Object>> result = this.queryPropertyBySchema(schemaCode);
        HashMap<String, String> r = new HashMap<String, String>();
        if (Beans.isNotEmpty(result)) {
            for (Map<String, Object> m : result) {
                r.put(m.get("pKey").toString(), m.get("pValue").toString());
            }
        }
        return r;
    }

    public List<Map<String, Object>> queryPropertyBySchema(String schemaCode) {
        String sql = "select schema_code as schemaCode,p_key as pKey,p_value as pValue from schema_property a where a.schema_code = '" + schemaCode + "'";
        List result = this.jdbcTemplate.queryForList(sql);
        return result;
    }

    public boolean saveOrUpdateProperty(String schemaCode, String key, String value) {
        String sql = "insert into schema_property(schema_code,p_key,p_value) values(?,?,?) ON DUPLICATE KEY UPDATE p_value = ?";
        Object[] args = new Object[]{schemaCode, key, value, value};
        int r = this.jdbcTemplate.update(sql, args);
        return r > 0;
    }

    public boolean deleteProperty(String schemaCode, String key) {
        String sql = "delete a.* from schema_property a where a.schema_code = ? and a.p_key = ?";
        Object[] args = new Object[]{schemaCode, key};
        int r = this.jdbcTemplate.update(sql, args);
        return r > 0;
    }

    public Page findPropertyByPage(String schemaCode, String key, int pageNo, int pageSize) {
        String sql = "select schema_code as schemaCode,p_key as pKey,p_value as pValue from schema_property a where a.schema_code = ?";
        ArrayList<String> args = new ArrayList<String>();
        args.add(schemaCode);
        if (Beans.isNotEmpty((Object)key)) {
            sql = sql + " and a.p_key like ?";
            args.add(key + "%");
        }
        return this.findByPage(sql, args, pageNo, pageSize);
    }

    public boolean copySchema(String copyCode, String schemaCode, String schemaName) {
        this.saveSchema(schemaCode, schemaName);
        List<Map<String, Object>> data = this.queryPropertyBySchema(copyCode);
        int[] result = new int[]{};
        ArrayList<Object[]> args = new ArrayList<Object[]>();
        if (Beans.isNotEmpty(data)) {
            String sql = "insert into schema_property(schema_code,p_key,p_value) values(?,?,?)";
            for (Map<String, Object> m : data) {
                Object[] arg = new Object[]{schemaCode, m.get("pKey"), m.get("pValue")};
                args.add(arg);
            }
            result = this.jdbcTemplate.batchUpdate(sql, args);
        }
        return result.length > 0;
    }
}

