/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.util;

import com.tcbj.util.Beans;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanMap {
    private static ThreadLocal<Map<Class<?>, PropertyDescriptor[]>> TL = new ThreadLocal();
    private Object obj;
    private Map<String, InnerEntry> entryMap;
    private Set<InnerEntry> entrySet;
    public static final Object[] NULL_ARGUMENTS = new Object[0];

    public BeanMap(Object obj) {
        this.obj = obj;
        this.entryMap();
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Class c) throws IntrospectionException {
        PropertyDescriptor[] propertyDescriptors;
        Map<Class<?>, PropertyDescriptor[]> propertyDescriptorsMap = TL.get();
        if (propertyDescriptorsMap == null) {
            propertyDescriptorsMap = new HashMap();
            TL.set(propertyDescriptorsMap);
        }
        if ((propertyDescriptors = propertyDescriptorsMap.get(c)) == null) {
            propertyDescriptors = Introspector.getBeanInfo(c).getPropertyDescriptors();
            propertyDescriptorsMap.put(c, propertyDescriptors);
        }
        return propertyDescriptors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, InnerEntry> entryMap() {
        if (this.entryMap == null) {
            BeanMap beanMap = this;
            synchronized (beanMap) {
                try {
                    this.entryMap = new HashMap<String, InnerEntry>();
                    if (this.obj == null) {
                        return this.entryMap;
                    }
                    for (PropertyDescriptor propertyDescriptor : BeanMap.getPropertyDescriptors(this.obj.getClass())) {
                        if ("class".equals(propertyDescriptor.getName())) continue;
                        String name = propertyDescriptor.getName();
                        if (this.entryMap.containsKey(name)) {
                            throw new RuntimeException(String.format("transform error,%s repeated", name));
                        }
                        InnerEntry entry = new InnerEntry(propertyDescriptor, name);
                        this.entryMap.put(name, entry);
                    }
                }
                catch (IntrospectionException e) {
                    e.printStackTrace();
                }
            }
        }
        Collections.unmodifiableMap(this.entryMap);
        return this.entryMap;
    }

    public boolean containsKey(Object key) {
        return this.entryMap.containsKey(key);
    }

    public Object put(Object key, Object value) {
        InnerEntry entry = this.entryMap.get(key);
        if (entry == null) {
            throw new RuntimeException("this obj have no field name:" + key);
        }
        return entry.setValue(value);
    }

    public Set<String> keySet() {
        return this.entryMap.keySet();
    }

    public Object get(Object key) {
        InnerEntry entry = this.entryMap.get(key);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<InnerEntry> entrySet() {
        if (this.entrySet == null) {
            BeanMap beanMap = this;
            synchronized (beanMap) {
                this.entrySet = new AbstractSet<InnerEntry>(){

                    @Override
                    public Iterator<InnerEntry> iterator() {
                        return BeanMap.this.entryMap.values().iterator();
                    }

                    @Override
                    public int size() {
                        return BeanMap.this.entryMap.size();
                    }
                };
                this.entrySet = Collections.unmodifiableSet(this.entrySet);
            }
        }
        return this.entrySet;
    }

    public int size() {
        return this.entryMap.size();
    }

    public class InnerEntry {
        private PropertyDescriptor pd;
        private String key;

        public InnerEntry(PropertyDescriptor pd, String key) {
            this.pd = pd;
            this.key = key;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            try {
                Method m = this.pd.getReadMethod();
                if (Beans.isEmpty(m)) {
                    return null;
                }
                m.setAccessible(true);
                return m.invoke(BeanMap.this.obj, NULL_ARGUMENTS);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public Object setValue(Object value) {
            Object old = this.getValue();
            try {
                Method m = this.pd.getWriteMethod();
                if (Beans.isEmpty(m)) {
                    return old;
                }
                m.setAccessible(true);
                m.invoke(BeanMap.this.obj, value);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return old;
        }

        public Class getType() {
            return this.pd.getPropertyType();
        }
    }
}

