/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.util;

import com.tcbj.util.BeanMap;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Beans {
    private Beans() {
    }

    public static void copy(Object target, Object source, String[] exclude, boolean copyNull) {
        BeanMap targetMap = new BeanMap(target);
        BeanMap sourceMap = new BeanMap(source);
        List<String> excludeList = Beans.isEmpty(exclude) ? null : Arrays.asList(exclude);
        try {
            for (BeanMap.InnerEntry entry : targetMap.entrySet()) {
                if (Collection.class.isAssignableFrom(entry.getType()) || Array.class.isAssignableFrom(entry.getType()) || Map.class.isAssignableFrom(entry.getType()) || !Beans.isEmpty(excludeList) && excludeList.contains(entry.getKey())) continue;
                Object value = sourceMap.get(entry.getKey());
                if (!copyNull && Beans.isEmpty(value)) continue;
                targetMap.put(entry.getKey(), value);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("copy error");
        }
    }

    public static void copy(Object target, Object source) {
        Beans.copy(target, source, null, false);
    }

    public static boolean isNotEmpty(Object obj) {
        return !Beans.isEmpty(obj);
    }

    public static Object deepCopy(Object sourceObject) {
        if (sourceObject == null) {
            return null;
        }
        if (sourceObject.getClass().isPrimitive()) {
            return sourceObject;
        }
        if (sourceObject instanceof CharSequence) {
            return sourceObject;
        }
        if (sourceObject instanceof Date) {
            return sourceObject;
        }
        if (sourceObject instanceof Number) {
            return sourceObject;
        }
        if (sourceObject instanceof Boolean) {
            return sourceObject;
        }
        if (sourceObject instanceof Character) {
            return sourceObject;
        }
        if (sourceObject instanceof Byte) {
            return sourceObject;
        }
        if (sourceObject.getClass().isArray()) {
            Object newArray = Array.newInstance(sourceObject.getClass().getComponentType(), Array.getLength(sourceObject));
            for (int i = 0; i < Array.getLength(sourceObject); ++i) {
                Object old = Array.get(sourceObject, i);
                Object clone = Beans.deepCopy(old);
                Array.set(newArray, i, clone);
            }
            return newArray;
        }
        if (sourceObject instanceof List) {
            List oldList = (List)sourceObject;
            LinkedList<Object> newList = new LinkedList<Object>();
            for (Object o : oldList) {
                newList.add(Beans.deepCopy(o));
            }
            return newList;
        }
        if (sourceObject instanceof Set) {
            Set oldList = (Set)sourceObject;
            LinkedHashSet<Object> newList = new LinkedHashSet<Object>();
            for (Object o : oldList) {
                newList.add(Beans.deepCopy(o));
            }
            return newList;
        }
        if (sourceObject instanceof Map) {
            Map oldMap = (Map)sourceObject;
            LinkedHashMap<Object, Object> newMap = new LinkedHashMap<Object, Object>();
            for (Object key : oldMap.keySet()) {
                newMap.put(Beans.deepCopy(key), Beans.deepCopy(oldMap.get(key)));
            }
            return newMap;
        }
        try {
            Object newObject = sourceObject.getClass().newInstance();
            BeanMap oldBeanMap = new BeanMap(sourceObject);
            BeanMap newBeanMap = new BeanMap(newObject);
            for (String key : oldBeanMap.keySet()) {
                newBeanMap.put(key, Beans.deepCopy(oldBeanMap.get(key)));
            }
            return newObject;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof CharSequence) {
            return ((CharSequence)obj).length() == 0;
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).isEmpty();
        }
        if (obj instanceof Map) {
            return ((Map)obj).isEmpty();
        }
        if (obj instanceof Object[]) {
            Object[] object = (Object[])obj;
            if (object.length == 0) {
                return true;
            }
            boolean empty = true;
            for (int i = 0; i < object.length; ++i) {
                if (Beans.isEmpty(object[i])) continue;
                empty = false;
                break;
            }
            return empty;
        }
        return false;
    }

    public static boolean isPropertyNull(Object obj, Object[] property) {
        List<Object> prop;
        BeanMap map = new BeanMap(obj);
        List<Object> list = prop = Beans.isEmpty(property) ? new ArrayList() : Arrays.asList(property);
        if (Beans.isEmpty(prop)) {
            for (String p : map.keySet()) {
                if (!Beans.isEmpty(map.get(p))) continue;
                return true;
            }
        } else {
            for (Object p : prop) {
                if (!Beans.isEmpty(map.get(p))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isPropertyNull(Object obj) {
        return Beans.isPropertyNull(obj, null);
    }

    public static void main(String[] args) throws Exception {
    }
}

