/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.springframework.util.StringUtils;

public class DateUtils {
    public static Date now() {
        return new Date();
    }

    public static long getDays(Date from, Date to) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        long fromTime = from.getTime();
        long toTime = to.getTime();
        return (toTime - fromTime) / 86400000L;
    }

    public static Date getFirstDay(int year, int month) {
        String _month = month > 9 ? "" + month : "0" + month;
        Date firstDay = DateUtils.now();
        String startDt = year + "-" + _month + "-" + "01";
        try {
            firstDay = new SimpleDateFormat("yyyy-MM-dd").parse(startDt);
        }
        catch (Exception e) {
            // empty catch block
        }
        return firstDay;
    }

    public static Date getLastDay(int year, int month) {
        String _month = month > 9 ? "" + month : "0" + month;
        int days = DateUtils.getDaysByYearMonth(year, month);
        String _days = days > 9 ? "" + days : "0" + days;
        Date lastDay = DateUtils.now();
        String endDt = year + "-" + _month + "-" + _days;
        try {
            lastDay = new SimpleDateFormat("yyyy-MM-dd").parse(endDt);
        }
        catch (Exception e) {
            // empty catch block
        }
        return lastDay;
    }

    public static Date getDateBeforeHour(Date date, int hour) {
        if (date == null) {
            date = DateUtils.now();
        }
        Calendar now = Calendar.getInstance();
        now.setTime(date);
        now.set(10, now.get(10) - hour);
        return now.getTime();
    }

    public static Date getDateBefore(Date date, int days) {
        if (date == null) {
            date = DateUtils.now();
        }
        Calendar now = Calendar.getInstance();
        now.setTime(date);
        now.set(5, now.get(5) - days);
        return now.getTime();
    }

    public static Date getDateBeforeMonth(Date date, int months) {
        if (date == null) {
            date = DateUtils.now();
        }
        Calendar now = Calendar.getInstance();
        now.setTime(date);
        now.set(2, now.get(2) - months);
        return now.getTime();
    }

    public static Date getDateAfter(Date date, int days) {
        if (date == null) {
            date = DateUtils.now();
        }
        Calendar now = Calendar.getInstance();
        now.setTime(date);
        now.set(5, now.get(5) + days);
        return now.getTime();
    }

    public static Date getDateAfterYear(Date date, int year) {
        if (date == null) {
            date = DateUtils.now();
        }
        Calendar now = Calendar.getInstance();
        now.setTime(date);
        now.set(1, now.get(1) + year);
        return now.getTime();
    }

    public static String getDate(Date date, String format) {
        if (date == null) {
            date = DateUtils.now();
        }
        return new SimpleDateFormat(format).format(date);
    }

    public static String getCurrentDate(String format) {
        return DateUtils.getDate(new Date(), format);
    }

    public static String getCurrentDate() {
        return DateUtils.getCurrentDate("yyyy-MM-dd");
    }

    public static String formartDate(Date date, String formatStr) {
        if (date == null) {
            date = DateUtils.now();
        }
        if (StringUtils.isEmpty((Object)formatStr)) {
            formatStr = "MM/dd/yyyy";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(formatStr);
        return sdf.format(date);
    }

    public static String formartDate2(Date date, String formatStr) {
        if (date == null) {
            return "";
        }
        if (StringUtils.isEmpty((Object)formatStr)) {
            formatStr = "MM/dd/yyyy";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(formatStr);
        return sdf.format(date);
    }

    public static Date formDate(String dateStr, String formatStr) {
        SimpleDateFormat sdf = new SimpleDateFormat(formatStr);
        Date date = null;
        try {
            date = sdf.parse(dateStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static Date getStartTime() {
        Calendar todayStart = Calendar.getInstance();
        todayStart.set(10, 0);
        todayStart.set(12, 0);
        todayStart.set(13, 0);
        todayStart.set(14, 0);
        return todayStart.getTime();
    }

    public static Date getStartTime(Date dt) {
        Calendar todayStart = Calendar.getInstance();
        todayStart.setTime(dt);
        todayStart.set(10, 0);
        todayStart.set(12, 0);
        todayStart.set(13, 0);
        todayStart.set(14, 0);
        return todayStart.getTime();
    }

    public static Date getEndTime() {
        Calendar todayEnd = Calendar.getInstance();
        todayEnd.set(1, 4028);
        todayEnd.set(11, 23);
        todayEnd.set(12, 59);
        todayEnd.set(13, 59);
        todayEnd.set(14, 999);
        return todayEnd.getTime();
    }

    public static Date getEndTime(Date dt) {
        Calendar todayEnd = Calendar.getInstance();
        todayEnd.setTime(dt);
        todayEnd.set(11, 23);
        todayEnd.set(12, 59);
        todayEnd.set(13, 59);
        todayEnd.set(14, 999);
        return todayEnd.getTime();
    }

    public static long timeCompare(Date start, Date end) {
        Calendar aCalendar = Calendar.getInstance();
        aCalendar.setTime(start);
        int day1 = aCalendar.get(6);
        aCalendar.setTime(end);
        int day2 = aCalendar.get(6);
        return day2 - day1;
    }

    public static boolean compare(Date start, Date end) {
        Calendar aCalendar = Calendar.getInstance();
        aCalendar.setTime(start);
        int day1 = aCalendar.get(6);
        aCalendar.setTime(end);
        int day2 = aCalendar.get(6);
        return day2 - day1 >= 0;
    }

    public static int getYear() {
        Calendar a = Calendar.getInstance();
        return a.get(1);
    }

    public static int getMonth() {
        Calendar a = Calendar.getInstance();
        return a.get(2) + 1;
    }

    public static int getDate() {
        Calendar a = Calendar.getInstance();
        return a.get(5);
    }

    public static Date getDateWithOverTime(Date dt) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        return cal.getTime();
    }

    public static int getDaysByYearMonth(int year, int month) {
        Calendar a = Calendar.getInstance();
        a.set(1, year);
        a.set(2, month - 1);
        a.set(5, 1);
        a.roll(5, -1);
        int maxDate = a.get(5);
        return maxDate;
    }

    public static String dateToStr(Date date, String format) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat sdFormat = new SimpleDateFormat(format, Locale.getDefault());
        String str_Date = sdFormat.format(date);
        return str_Date;
    }

    public static String getNewDateBefore(Date date, String format, int days) {
        Date date_before = DateUtils.getDateBefore(date, days);
        if (date == null) {
            return "";
        }
        SimpleDateFormat sdFormat = new SimpleDateFormat(format, Locale.getDefault());
        String str_Date = sdFormat.format(date_before);
        return str_Date;
    }

    public static void main(String[] args) {
        System.out.println(DateUtils.dateToStr(DateUtils.getDateBefore(new Date(), 90), "yyyy-MM-dd"));
    }
}

