/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Excels {
    private static int EXCEL_03 = 3;
    private static int EXCEL_07 = 7;

    public static List<Map> readExcel(String fileName, int fromRow, int headLine) {
        List<Object> valueList = new ArrayList();
        String ExtensionName = Excels.getExtensionName(fileName);
        try {
            if (ExtensionName.equalsIgnoreCase("xls")) {
                valueList = Excels.readExcel2003(fileName, fromRow, headLine);
            } else if (ExtensionName.equalsIgnoreCase("xlsx")) {
                valueList = Excels.readExcel2007(fileName, fromRow, headLine);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("error reading excel:" + e);
        }
        return valueList;
    }

    public static List<Map> readExcel(String fileName) {
        return Excels.readExcel(fileName, 1, 0);
    }

    public static List<Map> readExcel2003(String filePath, int fromRow, int headLine) throws IOException {
        FileInputStream fis = new FileInputStream(filePath);
        return Excels.readExcel(fis, EXCEL_03, fromRow, headLine);
    }

    public static List<Map> readExcel2007(String filePath, int fromRow, int headLine) throws IOException {
        FileInputStream fis = new FileInputStream(filePath);
        return Excels.readExcel(fis, EXCEL_07, fromRow, headLine);
    }

    public static List<Map> readExcel(InputStream is, int type, int fromRow, int headLine) {
        ArrayList<Map> valueList = new ArrayList<Map>();
        Workbook workbook = null;
        try {
            workbook = Excels.getWorkbook(type, is);
            Sheet sheet = workbook.getSheetAt(0);
            int rows = sheet.getPhysicalNumberOfRows();
            int cells = sheet.getRow(headLine).getPhysicalNumberOfCells();
            for (int i = fromRow; i < rows; ++i) {
                Row row = sheet.getRow(i);
                if (row == null) continue;
                HashMap<Integer, String> val = new HashMap<Integer, String>();
                boolean isValidRow = false;
                for (int j = 0; j < cells; ++j) {
                    try {
                        Cell cell = row.getCell(j);
                        String cellValue = Excels.getCellValue(cell);
                        val.put(j, cellValue);
                        if (isValidRow || cellValue == null || cellValue.trim().length() <= 0) continue;
                        isValidRow = true;
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (!isValidRow) continue;
                valueList.add(val);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("error reading excel:" + e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (workbook != null) {
                    workbook.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return valueList;
    }

    private static Workbook getWorkbook(int type, InputStream is) throws Exception {
        HSSFWorkbook wb = null;
        if (EXCEL_03 == type) {
            wb = new HSSFWorkbook(is);
        } else if (EXCEL_07 == type) {
            wb = new XSSFWorkbook(is);
        }
        return wb;
    }

    public static String getExtensionName(String filename) {
        int dot;
        if (filename != null && filename.length() > 0 && (dot = filename.lastIndexOf(46)) > -1 && dot < filename.length() - 1) {
            return filename.substring(dot + 1);
        }
        return filename;
    }

    private static String getCellValue(Cell cell) {
        DecimalFormat df = new DecimalFormat("#");
        String cellValue = null;
        if (cell == null) {
            return null;
        }
        switch (cell.getCellType()) {
            case 0: {
                if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    cellValue = sdf.format(HSSFDateUtil.getJavaDate((double)cell.getNumericCellValue()));
                    break;
                }
                cellValue = df.format(cell.getNumericCellValue());
                break;
            }
            case 1: {
                cellValue = String.valueOf(cell.getStringCellValue());
                break;
            }
            case 2: {
                cellValue = String.valueOf(cell.getCellFormula());
                break;
            }
            case 3: {
                cellValue = null;
                break;
            }
            case 4: {
                cellValue = String.valueOf(cell.getBooleanCellValue());
                break;
            }
            case 5: {
                cellValue = String.valueOf(cell.getErrorCellValue());
            }
        }
        if (cellValue != null && cellValue.trim().length() <= 0) {
            cellValue = null;
        }
        return cellValue;
    }

    public static void main(String[] args) throws Exception {
        String path = "e:\\test.xlsx";
        List<Map> value = Excels.readExcel(path, 2, 1);
        Excels.print(value);
    }

    private static void print(List<Map> list) {
        for (Map map : list) {
            for (Object o : map.keySet()) {
                System.out.print(map.get(o) + " ,");
            }
            System.out.println();
        }
    }
}

