/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.util;

import com.tcbj.util.Jsons;
import java.io.InputStream;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.commons.io.IOUtils;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseFactory;
import org.apache.http.ParseException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.MessageConstraints;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.HttpConnectionFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultHttpResponseParser;
import org.apache.http.impl.conn.DefaultHttpResponseParserFactory;
import org.apache.http.impl.conn.ManagedHttpClientConnectionFactory;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.io.DefaultHttpRequestWriterFactory;
import org.apache.http.io.HttpMessageParser;
import org.apache.http.io.HttpMessageParserFactory;
import org.apache.http.io.HttpMessageWriterFactory;
import org.apache.http.io.SessionInputBuffer;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicLineParser;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.message.LineParser;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.CharArrayBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Https {
    private static final Logger logger = LoggerFactory.getLogger(Https.class);
    private static Https instance = null;
    private CloseableHttpClient httpClient = null;
    private static Map<String, String> GET_HEADER = new HashMap<String, String>();
    private static Map<String, String> POST_HEADER = new HashMap<String, String>();
    private static Map<String, String> POST_XML_HEADER = new HashMap<String, String>();
    private static Map<String, String> POST_JSON_HEADER = new HashMap<String, String>();

    private Https() {
        this(255, 25600, 5000, 60000);
    }

    private Https(int conPerRoute, int totalConns, int connTimeout, int soTimeout) {
        DefaultHttpResponseParserFactory responseParserFactory = new DefaultHttpResponseParserFactory(){

            public HttpMessageParser<HttpResponse> create(SessionInputBuffer buffer, MessageConstraints constraints) {
                BasicLineParser lineParser = new BasicLineParser(){

                    public Header parseHeader(CharArrayBuffer buffer) {
                        try {
                            return super.parseHeader(buffer);
                        }
                        catch (ParseException ex) {
                            return new BasicHeader(buffer.toString(), null);
                        }
                    }
                };
                return new DefaultHttpResponseParser(buffer, (LineParser)lineParser, (HttpResponseFactory)DefaultHttpResponseFactory.INSTANCE, constraints){

                    protected boolean reject(CharArrayBuffer line, int count) {
                        return false;
                    }
                };
            }
        };
        DefaultHttpRequestWriterFactory requestWriterFactory = new DefaultHttpRequestWriterFactory();
        ManagedHttpClientConnectionFactory connFactory = new ManagedHttpClientConnectionFactory((HttpMessageWriterFactory)requestWriterFactory, (HttpMessageParserFactory)responseParserFactory);
        SSLContext sslcontext = SSLContexts.createSystemDefault();
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(sslcontext)).build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry, (HttpConnectionFactory)connFactory);
        SocketConfig socketConfig = SocketConfig.custom().setTcpNoDelay(true).build();
        connManager.setDefaultSocketConfig(socketConfig);
        connManager.setValidateAfterInactivity(1000);
        MessageConstraints messageConstraints = MessageConstraints.custom().setMaxHeaderCount(200).setMaxLineLength(2000).build();
        ConnectionConfig connectionConfig = ConnectionConfig.custom().setMalformedInputAction(CodingErrorAction.IGNORE).setUnmappableInputAction(CodingErrorAction.IGNORE).setCharset(Consts.UTF_8).setMessageConstraints(messageConstraints).build();
        connManager.setDefaultConnectionConfig(connectionConfig);
        connManager.setMaxTotal(totalConns);
        connManager.setDefaultMaxPerRoute(conPerRoute);
        BasicCookieStore cookieStore = new BasicCookieStore();
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        RequestConfig defaultRequestConfig = RequestConfig.custom().setCookieSpec("default").setExpectContinueEnabled(true).setTargetPreferredAuthSchemes(Arrays.asList("NTLM", "Digest")).setProxyPreferredAuthSchemes(Arrays.asList("Basic")).setConnectTimeout(connTimeout).setConnectionRequestTimeout(soTimeout).build();
        this.httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).setDefaultCookieStore((CookieStore)cookieStore).setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).setDefaultRequestConfig(defaultRequestConfig).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Https getInstance() {
        if (null != instance) return instance;
        Class<Https> clazz = Https.class;
        synchronized (Https.class) {
            instance = new Https();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public String get(String url) {
        logger.info("request get:" + url);
        HttpGet get = new HttpGet(url);
        this.setHeader((HttpRequestBase)get, GET_HEADER);
        try {
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)get);
            return this.handleResponse(response);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String post(String url, Map<String, String> param) {
        logger.info("request post:" + url + "," + Jsons.toJson(param));
        HttpPost post = new HttpPost(url);
        this.setHeader((HttpRequestBase)post, POST_HEADER);
        ArrayList<BasicNameValuePair> content = new ArrayList<BasicNameValuePair>();
        for (String key : param.keySet()) {
            BasicNameValuePair nvp = new BasicNameValuePair(key, param.get(key));
            content.add(nvp);
        }
        try {
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(content));
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)post);
            return this.handleResponse(response);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String post(String url, String content, Map<String, String> header) {
        logger.info("request post:" + url + "," + content);
        HttpPost post = new HttpPost(url);
        this.setHeader((HttpRequestBase)post, header);
        try {
            post.setEntity((HttpEntity)new StringEntity(content));
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)post);
            return this.handleResponse(response);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String postXml(String url, String xml) {
        return this.post(url, xml, POST_XML_HEADER);
    }

    public String postJson(String url, String json) {
        return this.post(url, json, POST_JSON_HEADER);
    }

    private void setHeader(HttpRequestBase base, Map<String, String> header) {
        for (String key : header.keySet()) {
            base.setHeader(key, header.get(key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String handleResponse(CloseableHttpResponse response) throws Exception {
        InputStream is = null;
        try {
            if (200 == response.getStatusLine().getStatusCode()) {
                HttpEntity entity = response.getEntity();
                is = entity.getContent();
                String resp = IOUtils.toString((InputStream)is);
                logger.info("response:" + resp);
                String string = resp;
                return string;
            }
        }
        finally {
            response.close();
        }
        return null;
    }

    static {
        GET_HEADER.put("accept", "*/*");
        GET_HEADER.put("Accept-Language", "en-us,en");
        GET_HEADER.put("user-agent", "Mozilla/5.0 (Windows NT 6.1; rv:2.0.1) Gecko/20100101 Firefox/4.0.1");
        GET_HEADER.put("Accept-Charset", Consts.UTF_8 + ",*");
        GET_HEADER.put("Keep-Alive", "60");
        GET_HEADER.put("Connection", "keep-alive");
        GET_HEADER.put("Cache-Control", "max-age=0");
        POST_HEADER.put("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        POST_HEADER.put("Content-Type", "application/x-www-form-urlencoded");
        POST_HEADER.put("Accept-Charset", Consts.UTF_8 + ",*");
        POST_HEADER.put("Pragma", "no-cache");
        POST_HEADER.put("Cache-Control", "no-cache");
        POST_HEADER.put("Comp-Control", "dsmp/sms-mt");
        POST_XML_HEADER.put("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        POST_XML_HEADER.put("Content-Type", "text/xml; charset=" + Consts.UTF_8);
        POST_XML_HEADER.put("Accept-Charset", Consts.UTF_8 + ",*");
        POST_XML_HEADER.put("Pragma", "no-cache");
        POST_XML_HEADER.put("Cache-Control", "no-cache");
        POST_XML_HEADER.put("Comp-Control", "dsmp/sms-mt");
        POST_JSON_HEADER.put("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        POST_JSON_HEADER.put("Content-Type", "application/json; charset=utf-8");
        POST_JSON_HEADER.put("Accept-Charset", "UTF-8,*");
        POST_JSON_HEADER.put("Pragma", "no-cache");
        POST_JSON_HEADER.put("Cache-Control", "no-cache");
        POST_JSON_HEADER.put("Comp-Control", "dsmp/sms-mt");
    }
}

