/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.util;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import javax.imageio.ImageIO;

public class ImageUtil {
    public static BufferedImage resize(BufferedImage source, int targetW, int targetH) {
        double sy;
        int type = source.getType();
        BufferedImage target = null;
        double sx = (double)targetW / (double)source.getWidth();
        if (sx > (sy = (double)targetH / (double)source.getHeight())) {
            sx = sy;
            targetW = (int)(sx * (double)source.getWidth());
        } else {
            sy = sx;
            targetH = (int)(sy * (double)source.getHeight());
        }
        if (type == 0) {
            ColorModel cm = source.getColorModel();
            WritableRaster raster = cm.createCompatibleWritableRaster(targetW, targetH);
            boolean alphaPremultiplied = cm.isAlphaPremultiplied();
            target = new BufferedImage(cm, raster, alphaPremultiplied, null);
        } else {
            target = new BufferedImage(targetW, targetH, type);
        }
        Graphics2D g = target.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.drawRenderedImage(source, AffineTransform.getScaleInstance(sx, sy));
        g.dispose();
        return target;
    }

    public static void saveImageAsJpg(String fromFileStr, String saveToFileStr, int width, int hight) throws Exception {
        String imgType = "JPEG";
        if (fromFileStr.toLowerCase().endsWith(".png")) {
            imgType = "PNG";
        }
        File saveFile = new File(saveToFileStr);
        File fromFile = new File(fromFileStr);
        BufferedImage srcImage = ImageIO.read(fromFile);
        if (width > 0 || hight > 0) {
            srcImage = ImageUtil.resize(srcImage, width, hight);
        }
        ImageIO.write((RenderedImage)srcImage, imgType, saveFile);
    }

    public static void main(String[] argv) {
        try {
            ImageUtil.saveImageAsJpg("f:/default_logo.gif", "f:/default_logo2.gif", 50, 50);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

