/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.util;

import java.math.BigDecimal;
import java.text.DecimalFormat;

public class MathUtils {
    public static Double m21(Double d) {
        return MathUtils.m2(d, 1);
    }

    public static Double m2(Double d, int len) {
        if (d == null) {
            return null;
        }
        BigDecimal bg = new BigDecimal(d);
        return bg.setScale(len, 4).doubleValue();
    }

    public static Double add(Double a, Double b) {
        if (a == null) {
            a = 0.0;
        }
        if (b == null) {
            b = 0.0;
        }
        BigDecimal aa = new BigDecimal(Double.toString(a));
        BigDecimal bb = new BigDecimal(Double.toString(b));
        BigDecimal cc = aa.add(bb);
        return cc.doubleValue();
    }

    public static Double sub(Double a, Double b) {
        if (a == null) {
            a = 0.0;
        }
        if (b == null) {
            b = 0.0;
        }
        BigDecimal aa = new BigDecimal(Double.toString(a));
        BigDecimal bb = new BigDecimal(Double.toString(b));
        BigDecimal cc = aa.subtract(bb);
        return cc.doubleValue();
    }

    public static Double mul(Double a, Double b) {
        if (a == null) {
            a = 0.0;
        }
        if (b == null) {
            b = 0.0;
        }
        BigDecimal aa = new BigDecimal(Double.toString(a));
        BigDecimal bb = new BigDecimal(Double.toString(b));
        BigDecimal cc = aa.multiply(bb);
        return cc.doubleValue();
    }

    public static Double div(Double a, Double b) {
        if (a == null) {
            a = 0.0;
        }
        if (b == null) {
            b = 0.0;
        }
        BigDecimal aa = new BigDecimal(Double.toString(a));
        BigDecimal bb = new BigDecimal(Double.toString(b));
        BigDecimal cc = aa.divide(bb);
        return cc.doubleValue();
    }

    public static Double div(Double a, Double b, Integer size) {
        if (a == null) {
            a = 0.0;
        }
        if (b == null) {
            b = 0.0;
        }
        BigDecimal aa = new BigDecimal(Double.toString(a));
        BigDecimal bb = new BigDecimal(Double.toString(b));
        BigDecimal cc = aa.divide(bb);
        return cc.setScale(2, 4).doubleValue();
    }

    public static Double format(Double d) {
        DecimalFormat df = new DecimalFormat("#.00");
        String r = df.format(d);
        return Double.valueOf(r);
    }

    public static Double getPrecision(Double d, Integer size) {
        if (size == null) {
            size = 1;
        }
        if (size == 0) {
            return MathUtils.getInt(d);
        }
        if (size == 1) {
            return MathUtils.getPrecision1(d);
        }
        return MathUtils.getPrecision2(d);
    }

    public static Double getInt(Double d) {
        String r = Double.toString(d);
        if (r.indexOf(".") > -1) {
            return Double.parseDouble(r.substring(0, r.indexOf(".")));
        }
        return d;
    }

    public static Double getPrecision1(Double d) {
        String r = Double.toString(d);
        if (r.indexOf(".") > -1) {
            r = r + "00";
            return Double.parseDouble(r.substring(0, r.indexOf(".") + 2));
        }
        return d;
    }

    public static Double getPrecision2(Double d) {
        String r = Double.toString(d);
        if (r.indexOf(".") > -1) {
            r = r + "00";
            return Double.parseDouble(r.substring(0, r.indexOf(".") + 3));
        }
        return d;
    }

    public static void main(String[] args) {
        System.out.println(MathUtils.getPrecision1(1235654.19343));
    }
}

