/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.util;

import java.awt.image.BufferedImage;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.jbarcode.JBarcode;
import org.jbarcode.encode.BarcodeEncoder;
import org.jbarcode.encode.CodabarEncoder;
import org.jbarcode.encode.Code128Encoder;
import org.jbarcode.encode.Code39Encoder;
import org.jbarcode.encode.Code93Encoder;
import org.jbarcode.encode.EAN13Encoder;
import org.jbarcode.encode.EAN8Encoder;
import org.jbarcode.encode.Interleaved2of5Encoder;
import org.jbarcode.encode.PostNetEncoder;
import org.jbarcode.encode.Standard2of5Encoder;
import org.jbarcode.encode.UPCAEncoder;
import org.jbarcode.encode.UPCEEncoder;
import org.jbarcode.paint.BaseLineTextPainter;
import org.jbarcode.paint.EAN13TextPainter;
import org.jbarcode.paint.EAN8TextPainter;
import org.jbarcode.paint.HeightCodedPainter;
import org.jbarcode.paint.UPCATextPainter;
import org.jbarcode.paint.UPCETextPainter;
import org.jbarcode.paint.WideRatioCodedPainter;
import org.jbarcode.paint.WidthCodedPainter;
import org.jbarcode.util.ImageUtil;

public class OneBarcodeUtil {
    public static void main(String[] paramArrayOfString) {
        try {
            JBarcode localJBarcode = new JBarcode((BarcodeEncoder)EAN13Encoder.getInstance(), WidthCodedPainter.getInstance(), EAN13TextPainter.getInstance());
            String str = "788515004012";
            BufferedImage localBufferedImage = localJBarcode.createBarcode(str);
            OneBarcodeUtil.saveToGIF(localBufferedImage, "EAN13.gif");
            localJBarcode.setEncoder((BarcodeEncoder)EAN8Encoder.getInstance());
            localJBarcode.setTextPainter(EAN8TextPainter.getInstance());
            str = "9788515";
            localBufferedImage = localJBarcode.createBarcode(str);
            OneBarcodeUtil.saveToPNG(localBufferedImage, "EAN8.png");
            localJBarcode.setEncoder((BarcodeEncoder)UPCAEncoder.getInstance());
            localJBarcode.setTextPainter(UPCATextPainter.getInstance());
            str = "07567816415";
            localBufferedImage = localJBarcode.createBarcode(str);
            OneBarcodeUtil.saveToPNG(localBufferedImage, "UPCA.png");
            localJBarcode.setEncoder((BarcodeEncoder)UPCEEncoder.getInstance());
            localJBarcode.setTextPainter(UPCETextPainter.getInstance());
            str = UPCAEncoder.getInstance().convertUPCAtoUPCE("07567816415");
            localBufferedImage = localJBarcode.createBarcode(str);
            OneBarcodeUtil.saveToPNG(localBufferedImage, "UPCE.png");
            localJBarcode.setEncoder((BarcodeEncoder)CodabarEncoder.getInstance());
            localJBarcode.setPainter(WideRatioCodedPainter.getInstance());
            localJBarcode.setTextPainter(BaseLineTextPainter.getInstance());
            str = "97885150040-85";
            localJBarcode.setWideRatio(3.0);
            localBufferedImage = localJBarcode.createBarcode(str);
            OneBarcodeUtil.saveToJPEG(localBufferedImage, "Codabar.jpg");
            localJBarcode.setEncoder(Code39Encoder.getInstance());
            localJBarcode.setPainter(WideRatioCodedPainter.getInstance());
            localJBarcode.setTextPainter(BaseLineTextPainter.getInstance());
            localJBarcode.setShowCheckDigit(false);
            str = "JBARCODE-39";
            localBufferedImage = localJBarcode.createBarcode(str);
            OneBarcodeUtil.saveToPNG(localBufferedImage, "Code39.png");
            localJBarcode.setEncoder(Code93Encoder.getInstance());
            localJBarcode.setPainter(WidthCodedPainter.getInstance());
            localJBarcode.setTextPainter(BaseLineTextPainter.getInstance());
            localJBarcode.setShowCheckDigit(false);
            str = "JBARCODE-93";
            localBufferedImage = localJBarcode.createBarcode(str);
            OneBarcodeUtil.saveToPNG(localBufferedImage, "Code93.png");
            localJBarcode.setEncoder((BarcodeEncoder)Code128Encoder.getInstance());
            localJBarcode.setPainter(WidthCodedPainter.getInstance());
            localJBarcode.setTextPainter(BaseLineTextPainter.getInstance());
            localJBarcode.setShowCheckDigit(false);
            str = "JBarcode-128";
            localBufferedImage = localJBarcode.createBarcode(str);
            OneBarcodeUtil.saveToPNG(localBufferedImage, "Code128.png");
            localJBarcode.setEncoder((BarcodeEncoder)Standard2of5Encoder.getInstance());
            localJBarcode.setPainter(WideRatioCodedPainter.getInstance());
            localJBarcode.setTextPainter(BaseLineTextPainter.getInstance());
            localJBarcode.setShowCheckDigit(true);
            str = "978851500404";
            localBufferedImage = localJBarcode.createBarcode(str);
            OneBarcodeUtil.saveToJPEG(localBufferedImage, "Standard2of5.jpg");
            localJBarcode.setEncoder((BarcodeEncoder)Interleaved2of5Encoder.getInstance());
            localJBarcode.setPainter(WideRatioCodedPainter.getInstance());
            localJBarcode.setTextPainter(BaseLineTextPainter.getInstance());
            localJBarcode.setShowCheckDigit(true);
            str = "978851500404";
            localBufferedImage = localJBarcode.createBarcode(str);
            OneBarcodeUtil.saveToPNG(localBufferedImage, "Interleaved2of5.png");
            localJBarcode.setEncoder((BarcodeEncoder)PostNetEncoder.getInstance());
            localJBarcode.setPainter(HeightCodedPainter.getInstance());
            localJBarcode.setBarHeight(6.0);
            localJBarcode.setXDimension(0.5291666);
            localJBarcode.setShowText(false);
            str = "805365961";
            localBufferedImage = localJBarcode.createBarcode(str);
            OneBarcodeUtil.saveToJPEG(localBufferedImage, "PostNet.jpg");
        }
        catch (Exception localException) {
            localException.printStackTrace();
        }
    }

    static void saveToJPEG(BufferedImage paramBufferedImage, String paramString) {
        OneBarcodeUtil.saveToFile(paramBufferedImage, paramString, "jpeg");
    }

    static void saveToPNG(BufferedImage paramBufferedImage, String paramString) {
        OneBarcodeUtil.saveToFile(paramBufferedImage, paramString, "png");
    }

    static void saveToGIF(BufferedImage paramBufferedImage, String paramString) {
        OneBarcodeUtil.saveToFile(paramBufferedImage, paramString, "gif");
    }

    static void saveToFile(BufferedImage paramBufferedImage, String paramString1, String paramString2) {
        try {
            FileOutputStream localFileOutputStream = new FileOutputStream("D:/images/" + paramString1);
            ImageUtil.encodeAndWrite((BufferedImage)paramBufferedImage, (String)paramString2, (OutputStream)localFileOutputStream, (int)96, (int)96);
            localFileOutputStream.close();
        }
        catch (Exception localException) {
            localException.printStackTrace();
        }
    }

    public static void saveToPNG(BufferedImage paramBufferedImage, String paramString, String path) {
        OneBarcodeUtil.saveToFile(paramBufferedImage, paramString, "png", path);
    }

    public static void saveToFile(BufferedImage paramBufferedImage, String paramString1, String paramString2, String path) {
        try {
            FileOutputStream localFileOutputStream = new FileOutputStream(path + paramString1);
            ImageUtil.encodeAndWrite((BufferedImage)paramBufferedImage, (String)paramString2, (OutputStream)localFileOutputStream, (int)96, (int)96);
            localFileOutputStream.close();
        }
        catch (Exception localException) {
            localException.printStackTrace();
        }
    }
}

