/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.util;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Packages {
    public static final String FILE_PROTOCOL = "file";

    public static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null) {
            cl = Packages.class.getClassLoader();
        }
        return cl;
    }

    private static Set<File> getFilesFromDir(String dirPath) {
        File[] files;
        HashSet<File> fileSet = new HashSet<File>();
        File dir = new File(dirPath);
        if (!dir.isDirectory()) {
            return new HashSet<File>();
        }
        for (File file : files = dir.listFiles()) {
            fileSet.add(file);
            if (!file.isDirectory()) continue;
            fileSet.addAll(Packages.getFilesFromDir(file.getAbsolutePath()));
        }
        return fileSet;
    }

    public static Set<Resource> findResources(String packageName) {
        String rootPath = packageName.replace(".", "/").trim();
        HashSet<Resource> resSet = new HashSet<Resource>();
        try {
            Enumeration<URL> eumn = Packages.getDefaultClassLoader().getResources(rootPath);
            while (eumn.hasMoreElements()) {
                URL url = eumn.nextElement();
                String protocol = url.getProtocol();
                if (!FILE_PROTOCOL.equals(protocol)) continue;
                String filePath = URLDecoder.decode(url.getFile(), "UTF-8");
                Set<File> resourceFile = Packages.getFilesFromDir(filePath);
                for (File classFile : resourceFile) {
                    if (!classFile.isFile()) continue;
                    String name = classFile.getAbsolutePath().substring(filePath.length());
                    String resourcePath = rootPath + "/" + name;
                    Resource resource = new Resource();
                    resource.name = name;
                    resource.path = "/" + resourcePath.replace('\\', '/');
                    resource.path = resource.path.replace("//", "/");
                    resSet.add(resource);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resSet;
    }

    public static void main(String[] args) throws Exception {
    }

    public static class Resource {
        public String path;
        public String name;

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Resource other = (Resource)obj;
            return !(this.path == null ? other.path != null : !this.path.equals(other.path));
        }

        public InputStream getStream() {
            return Resource.class.getResourceAsStream(this.path);
        }

        public String toString() {
            return "Resource [path=" + this.path + "]";
        }
    }
}

